/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseAssociationConfigurationData implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseAssociationConfigurationData.Builder, KnowledgeBaseAssociationConfigurationData> {
    private static final SdkField<TagFilter> CONTENT_TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .memberName("contentTagFilter").getter(getter(KnowledgeBaseAssociationConfigurationData::contentTagFilter))
            .setter(setter(Builder::contentTagFilter)).constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentTagFilter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(KnowledgeBaseAssociationConfigurationData::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("overrideKnowledgeBaseSearchType")
            .getter(getter(KnowledgeBaseAssociationConfigurationData::overrideKnowledgeBaseSearchTypeAsString))
            .setter(setter(Builder::overrideKnowledgeBaseSearchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideKnowledgeBaseSearchType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TAG_FILTER_FIELD,
            MAX_RESULTS_FIELD, OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TagFilter contentTagFilter;

    private final Integer maxResults;

    private final String overrideKnowledgeBaseSearchType;

    private KnowledgeBaseAssociationConfigurationData(BuilderImpl builder) {
        this.contentTagFilter = builder.contentTagFilter;
        this.maxResults = builder.maxResults;
        this.overrideKnowledgeBaseSearchType = builder.overrideKnowledgeBaseSearchType;
    }

    /**
     * Returns the value of the ContentTagFilter property for this object.
     * 
     * @return The value of the ContentTagFilter property for this object.
     */
    public final TagFilter contentTagFilter() {
        return contentTagFilter;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The search type to be used against the Knowledge Base for this request. The values can be <code>SEMANTIC</code>
     * which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw text
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideKnowledgeBaseSearchType} will return {@link KnowledgeBaseSearchType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #overrideKnowledgeBaseSearchTypeAsString}.
     * </p>
     * 
     * @return The search type to be used against the Knowledge Base for this request. The values can be
     *         <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and
     *         raw text
     * @see KnowledgeBaseSearchType
     */
    public final KnowledgeBaseSearchType overrideKnowledgeBaseSearchType() {
        return KnowledgeBaseSearchType.fromValue(overrideKnowledgeBaseSearchType);
    }

    /**
     * <p>
     * The search type to be used against the Knowledge Base for this request. The values can be <code>SEMANTIC</code>
     * which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw text
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overrideKnowledgeBaseSearchType} will return {@link KnowledgeBaseSearchType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #overrideKnowledgeBaseSearchTypeAsString}.
     * </p>
     * 
     * @return The search type to be used against the Knowledge Base for this request. The values can be
     *         <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and
     *         raw text
     * @see KnowledgeBaseSearchType
     */
    public final String overrideKnowledgeBaseSearchTypeAsString() {
        return overrideKnowledgeBaseSearchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentTagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(overrideKnowledgeBaseSearchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseAssociationConfigurationData)) {
            return false;
        }
        KnowledgeBaseAssociationConfigurationData other = (KnowledgeBaseAssociationConfigurationData) obj;
        return Objects.equals(contentTagFilter(), other.contentTagFilter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(overrideKnowledgeBaseSearchTypeAsString(), other.overrideKnowledgeBaseSearchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseAssociationConfigurationData").add("ContentTagFilter", contentTagFilter())
                .add("MaxResults", maxResults())
                .add("OverrideKnowledgeBaseSearchType", overrideKnowledgeBaseSearchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentTagFilter":
            return Optional.ofNullable(clazz.cast(contentTagFilter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "overrideKnowledgeBaseSearchType":
            return Optional.ofNullable(clazz.cast(overrideKnowledgeBaseSearchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentTagFilter", CONTENT_TAG_FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("overrideKnowledgeBaseSearchType", OVERRIDE_KNOWLEDGE_BASE_SEARCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseAssociationConfigurationData, T> g) {
        return obj -> g.apply((KnowledgeBaseAssociationConfigurationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseAssociationConfigurationData> {
        /**
         * Sets the value of the ContentTagFilter property for this object.
         *
         * @param contentTagFilter
         *        The new value for the ContentTagFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTagFilter(TagFilter contentTagFilter);

        /**
         * Sets the value of the ContentTagFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TagFilter.Builder} avoiding the need to
         * create one manually via {@link TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #contentTagFilter(TagFilter)}.
         * 
         * @param contentTagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentTagFilter(TagFilter)
         */
        default Builder contentTagFilter(Consumer<TagFilter.Builder> contentTagFilter) {
            return contentTagFilter(TagFilter.builder().applyMutation(contentTagFilter).build());
        }

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The search type to be used against the Knowledge Base for this request. The values can be
         * <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw
         * text
         * </p>
         * 
         * @param overrideKnowledgeBaseSearchType
         *        The search type to be used against the Knowledge Base for this request. The values can be
         *        <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings
         *        and raw text
         * @see KnowledgeBaseSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseSearchType
         */
        Builder overrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType);

        /**
         * <p>
         * The search type to be used against the Knowledge Base for this request. The values can be
         * <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings and raw
         * text
         * </p>
         * 
         * @param overrideKnowledgeBaseSearchType
         *        The search type to be used against the Knowledge Base for this request. The values can be
         *        <code>SEMANTIC</code> which uses vector embeddings or <code>HYBRID</code> which use vector embeddings
         *        and raw text
         * @see KnowledgeBaseSearchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseSearchType
         */
        Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType overrideKnowledgeBaseSearchType);
    }

    static final class BuilderImpl implements Builder {
        private TagFilter contentTagFilter;

        private Integer maxResults;

        private String overrideKnowledgeBaseSearchType;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseAssociationConfigurationData model) {
            contentTagFilter(model.contentTagFilter);
            maxResults(model.maxResults);
            overrideKnowledgeBaseSearchType(model.overrideKnowledgeBaseSearchType);
        }

        public final TagFilter.Builder getContentTagFilter() {
            return contentTagFilter != null ? contentTagFilter.toBuilder() : null;
        }

        public final void setContentTagFilter(TagFilter.BuilderImpl contentTagFilter) {
            this.contentTagFilter = contentTagFilter != null ? contentTagFilter.build() : null;
        }

        @Override
        public final Builder contentTagFilter(TagFilter contentTagFilter) {
            this.contentTagFilter = contentTagFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getOverrideKnowledgeBaseSearchType() {
            return overrideKnowledgeBaseSearchType;
        }

        public final void setOverrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(String overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
            return this;
        }

        @Override
        public final Builder overrideKnowledgeBaseSearchType(KnowledgeBaseSearchType overrideKnowledgeBaseSearchType) {
            this.overrideKnowledgeBaseSearchType(overrideKnowledgeBaseSearchType == null ? null : overrideKnowledgeBaseSearchType
                    .toString());
            return this;
        }

        @Override
        public KnowledgeBaseAssociationConfigurationData build() {
            return new KnowledgeBaseAssociationConfigurationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
