/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFeedbackResponse extends QConnectResponse implements
        ToCopyableBuilder<PutFeedbackResponse.Builder, PutFeedbackResponse> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(PutFeedbackResponse::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(PutFeedbackResponse::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetId").getter(getter(PutFeedbackResponse::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(PutFeedbackResponse::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final SdkField<ContentFeedbackData> CONTENT_FEEDBACK_FIELD = SdkField
            .<ContentFeedbackData> builder(MarshallingType.SDK_POJO).memberName("contentFeedback")
            .getter(getter(PutFeedbackResponse::contentFeedback)).setter(setter(Builder::contentFeedback))
            .constructor(ContentFeedbackData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentFeedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            ASSISTANT_ARN_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD, CONTENT_FEEDBACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String assistantArn;

    private final String targetId;

    private final String targetType;

    private final ContentFeedbackData contentFeedback;

    private PutFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.contentFeedback = builder.contentFeedback;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the feedback target.
     * </p>
     * 
     * @return The identifier of the feedback target.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The type of the feedback target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the feedback target.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of the feedback target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the feedback target.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    /**
     * <p>
     * Information about the feedback provided.
     * </p>
     * 
     * @return Information about the feedback provided.
     */
    public final ContentFeedbackData contentFeedback() {
        return contentFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackResponse)) {
            return false;
        }
        PutFeedbackResponse other = (PutFeedbackResponse) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(assistantArn(), other.assistantArn())
                && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString())
                && Objects.equals(contentFeedback(), other.contentFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFeedbackResponse").add("AssistantId", assistantId()).add("AssistantArn", assistantArn())
                .add("TargetId", targetId()).add("TargetType", targetTypeAsString()).add("ContentFeedback", contentFeedback())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "targetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        case "contentFeedback":
            return Optional.ofNullable(clazz.cast(contentFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("targetId", TARGET_ID_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        map.put("contentFeedback", CONTENT_FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackResponse, T> g) {
        return obj -> g.apply((PutFeedbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutFeedbackResponse> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the feedback target.
         * </p>
         * 
         * @param targetId
         *        The identifier of the feedback target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The type of the feedback target.
         * </p>
         * 
         * @param targetType
         *        The type of the feedback target.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of the feedback target.
         * </p>
         * 
         * @param targetType
         *        The type of the feedback target.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);

        /**
         * <p>
         * Information about the feedback provided.
         * </p>
         * 
         * @param contentFeedback
         *        Information about the feedback provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentFeedback(ContentFeedbackData contentFeedback);

        /**
         * <p>
         * Information about the feedback provided.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentFeedbackData.Builder} avoiding the
         * need to create one manually via {@link ContentFeedbackData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentFeedbackData.Builder#build()} is called immediately and
         * its result is passed to {@link #contentFeedback(ContentFeedbackData)}.
         * 
         * @param contentFeedback
         *        a consumer that will call methods on {@link ContentFeedbackData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentFeedback(ContentFeedbackData)
         */
        default Builder contentFeedback(Consumer<ContentFeedbackData.Builder> contentFeedback) {
            return contentFeedback(ContentFeedbackData.builder().applyMutation(contentFeedback).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private String assistantId;

        private String assistantArn;

        private String targetId;

        private String targetType;

        private ContentFeedbackData contentFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackResponse model) {
            super(model);
            assistantId(model.assistantId);
            assistantArn(model.assistantArn);
            targetId(model.targetId);
            targetType(model.targetType);
            contentFeedback(model.contentFeedback);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final ContentFeedbackData.Builder getContentFeedback() {
            return contentFeedback != null ? contentFeedback.toBuilder() : null;
        }

        public final void setContentFeedback(ContentFeedbackData.BuilderImpl contentFeedback) {
            this.contentFeedback = contentFeedback != null ? contentFeedback.build() : null;
        }

        @Override
        public final Builder contentFeedback(ContentFeedbackData contentFeedback) {
            this.contentFeedback = contentFeedback;
            return this;
        }

        @Override
        public PutFeedbackResponse build() {
            return new PutFeedbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
