/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenderMessageTemplateResponse extends QConnectResponse implements
        ToCopyableBuilder<RenderMessageTemplateResponse.Builder, RenderMessageTemplateResponse> {
    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField
            .<MessageTemplateContentProvider> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(RenderMessageTemplateResponse::content)).setter(setter(Builder::content))
            .constructor(MessageTemplateContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_NOT_INTERPOLATED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attributesNotInterpolated")
            .getter(getter(RenderMessageTemplateResponse::attributesNotInterpolated))
            .setter(setter(Builder::attributesNotInterpolated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributesNotInterpolated").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MessageTemplateAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<MessageTemplateAttachment>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(RenderMessageTemplateResponse::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTemplateAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTemplateAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            ATTRIBUTES_NOT_INTERPOLATED_FIELD, ATTACHMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MessageTemplateContentProvider content;

    private final List<String> attributesNotInterpolated;

    private final List<MessageTemplateAttachment> attachments;

    private RenderMessageTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.attributesNotInterpolated = builder.attributesNotInterpolated;
        this.attachments = builder.attachments;
    }

    /**
     * <p>
     * The content of the message template.
     * </p>
     * 
     * @return The content of the message template.
     */
    public final MessageTemplateContentProvider content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesNotInterpolated property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttributesNotInterpolated() {
        return attributesNotInterpolated != null && !(attributesNotInterpolated instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attribute keys that are not resolved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesNotInterpolated} method.
     * </p>
     * 
     * @return The attribute keys that are not resolved.
     */
    public final List<String> attributesNotInterpolated() {
        return attributesNotInterpolated;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The message template attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return The message template attachments.
     */
    public final List<MessageTemplateAttachment> attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesNotInterpolated() ? attributesNotInterpolated() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenderMessageTemplateResponse)) {
            return false;
        }
        RenderMessageTemplateResponse other = (RenderMessageTemplateResponse) obj;
        return Objects.equals(content(), other.content())
                && hasAttributesNotInterpolated() == other.hasAttributesNotInterpolated()
                && Objects.equals(attributesNotInterpolated(), other.attributesNotInterpolated())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenderMessageTemplateResponse").add("Content", content())
                .add("AttributesNotInterpolated", attributesNotInterpolated() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Attachments", hasAttachments() ? attachments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "attributesNotInterpolated":
            return Optional.ofNullable(clazz.cast(attributesNotInterpolated()));
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("attributesNotInterpolated", ATTRIBUTES_NOT_INTERPOLATED_FIELD);
        map.put("attachments", ATTACHMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenderMessageTemplateResponse, T> g) {
        return obj -> g.apply((RenderMessageTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, RenderMessageTemplateResponse> {
        /**
         * <p>
         * The content of the message template.
         * </p>
         * 
         * @param content
         *        The content of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(MessageTemplateContentProvider content);

        /**
         * <p>
         * The content of the message template.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageTemplateContentProvider.Builder}
         * avoiding the need to create one manually via {@link MessageTemplateContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #content(MessageTemplateContentProvider)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link MessageTemplateContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(MessageTemplateContentProvider)
         */
        default Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return content(MessageTemplateContentProvider.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The attribute keys that are not resolved.
         * </p>
         * 
         * @param attributesNotInterpolated
         *        The attribute keys that are not resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesNotInterpolated(Collection<String> attributesNotInterpolated);

        /**
         * <p>
         * The attribute keys that are not resolved.
         * </p>
         * 
         * @param attributesNotInterpolated
         *        The attribute keys that are not resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesNotInterpolated(String... attributesNotInterpolated);

        /**
         * <p>
         * The message template attachments.
         * </p>
         * 
         * @param attachments
         *        The message template attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<MessageTemplateAttachment> attachments);

        /**
         * <p>
         * The message template attachments.
         * </p>
         * 
         * @param attachments
         *        The message template attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(MessageTemplateAttachment... attachments);

        /**
         * <p>
         * The message template attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<MessageTemplateAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<MessageTemplateAttachment>)
         */
        Builder attachments(Consumer<MessageTemplateAttachment.Builder>... attachments);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private MessageTemplateContentProvider content;

        private List<String> attributesNotInterpolated = DefaultSdkAutoConstructList.getInstance();

        private List<MessageTemplateAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenderMessageTemplateResponse model) {
            super(model);
            content(model.content);
            attributesNotInterpolated(model.attributesNotInterpolated);
            attachments(model.attachments);
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        public final Collection<String> getAttributesNotInterpolated() {
            if (attributesNotInterpolated instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesNotInterpolated;
        }

        public final void setAttributesNotInterpolated(Collection<String> attributesNotInterpolated) {
            this.attributesNotInterpolated = MessageTemplateAttributeKeyListCopier.copy(attributesNotInterpolated);
        }

        @Override
        public final Builder attributesNotInterpolated(Collection<String> attributesNotInterpolated) {
            this.attributesNotInterpolated = MessageTemplateAttributeKeyListCopier.copy(attributesNotInterpolated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesNotInterpolated(String... attributesNotInterpolated) {
            attributesNotInterpolated(Arrays.asList(attributesNotInterpolated));
            return this;
        }

        public final List<MessageTemplateAttachment.Builder> getAttachments() {
            List<MessageTemplateAttachment.Builder> result = MessageTemplateAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<MessageTemplateAttachment.BuilderImpl> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<MessageTemplateAttachment> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(MessageTemplateAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<MessageTemplateAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> MessageTemplateAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RenderMessageTemplateResponse build() {
            return new RenderMessageTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
