/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultData implements SdkPojo, Serializable, ToCopyableBuilder<ResultData.Builder, ResultData> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultId").getter(getter(ResultData::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultId").build()).build();

    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.<Document> builder(MarshallingType.SDK_POJO)
            .memberName("document").getter(getter(ResultData::document)).setter(setter(Builder::document))
            .constructor(Document::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("relevanceScore").getter(getter(ResultData::relevanceScore)).setter(setter(Builder::relevanceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()).build();

    private static final SdkField<DataSummary> DATA_FIELD = SdkField.<DataSummary> builder(MarshallingType.SDK_POJO)
            .memberName("data").getter(getter(ResultData::data)).setter(setter(Builder::data)).constructor(DataSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ResultData::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD,
            DOCUMENT_FIELD, RELEVANCE_SCORE_FIELD, DATA_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resultId;

    private final Document document;

    private final Double relevanceScore;

    private final DataSummary data;

    private final String type;

    private ResultData(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.document = builder.document;
        this.relevanceScore = builder.relevanceScore;
        this.data = builder.data;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier of the result data.
     * </p>
     * 
     * @return The identifier of the result data.
     */
    public final String resultId() {
        return resultId;
    }

    /**
     * <p>
     * The document.
     * </p>
     * 
     * @return The document.
     */
    public final Document document() {
        return document;
    }

    /**
     * <p>
     * The relevance score of the results.
     * </p>
     * 
     * @return The relevance score of the results.
     */
    public final Double relevanceScore() {
        return relevanceScore;
    }

    /**
     * <p>
     * Summary of the recommended content.
     * </p>
     * 
     * @return Summary of the recommended content.
     */
    public final DataSummary data() {
        return data;
    }

    /**
     * <p>
     * The type of the query result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the query result.
     * @see QueryResultType
     */
    public final QueryResultType type() {
        return QueryResultType.fromValue(type);
    }

    /**
     * <p>
     * The type of the query result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the query result.
     * @see QueryResultType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(relevanceScore());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultData)) {
            return false;
        }
        ResultData other = (ResultData) obj;
        return Objects.equals(resultId(), other.resultId()) && Objects.equals(document(), other.document())
                && Objects.equals(relevanceScore(), other.relevanceScore()) && Objects.equals(data(), other.data())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultData").add("ResultId", resultId()).add("Document", document())
                .add("RelevanceScore", relevanceScore()).add("Data", data()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "relevanceScore":
            return Optional.ofNullable(clazz.cast(relevanceScore()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resultId", RESULT_ID_FIELD);
        map.put("document", DOCUMENT_FIELD);
        map.put("relevanceScore", RELEVANCE_SCORE_FIELD);
        map.put("data", DATA_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultData, T> g) {
        return obj -> g.apply((ResultData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultData> {
        /**
         * <p>
         * The identifier of the result data.
         * </p>
         * 
         * @param resultId
         *        The identifier of the result data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);

        /**
         * <p>
         * The document.
         * </p>
         * 
         * @param document
         *        The document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(Document document);

        /**
         * <p>
         * The document.
         * </p>
         * This is a convenience method that creates an instance of the {@link Document.Builder} avoiding the need to
         * create one manually via {@link Document#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Document.Builder#build()} is called immediately and its result is
         * passed to {@link #document(Document)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link Document.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(Document)
         */
        default Builder document(Consumer<Document.Builder> document) {
            return document(Document.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * The relevance score of the results.
         * </p>
         * 
         * @param relevanceScore
         *        The relevance score of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevanceScore(Double relevanceScore);

        /**
         * <p>
         * Summary of the recommended content.
         * </p>
         * 
         * @param data
         *        Summary of the recommended content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(DataSummary data);

        /**
         * <p>
         * Summary of the recommended content.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSummary.Builder} avoiding the need to
         * create one manually via {@link DataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSummary.Builder#build()} is called immediately and its result
         * is passed to {@link #data(DataSummary)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link DataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(DataSummary)
         */
        default Builder data(Consumer<DataSummary.Builder> data) {
            return data(DataSummary.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * The type of the query result.
         * </p>
         * 
         * @param type
         *        The type of the query result.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the query result.
         * </p>
         * 
         * @param type
         *        The type of the query result.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder type(QueryResultType type);
    }

    static final class BuilderImpl implements Builder {
        private String resultId;

        private Document document;

        private Double relevanceScore;

        private DataSummary data;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultData model) {
            resultId(model.resultId);
            document(model.document);
            relevanceScore(model.relevanceScore);
            data(model.data);
            type(model.type);
        }

        public final String getResultId() {
            return resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final Document.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final Double getRelevanceScore() {
            return relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        public final DataSummary.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(DataSummary.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(DataSummary data) {
            this.data = data;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryResultType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ResultData build() {
            return new ResultData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
