/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for AI Agents of type SELF_SERVICE.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfServiceAIAgentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfServiceAIAgentConfiguration.Builder, SelfServiceAIAgentConfiguration> {
    private static final SdkField<String> SELF_SERVICE_PRE_PROCESSING_AI_PROMPT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("selfServicePreProcessingAIPromptId")
            .getter(getter(SelfServiceAIAgentConfiguration::selfServicePreProcessingAIPromptId))
            .setter(setter(Builder::selfServicePreProcessingAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfServicePreProcessingAIPromptId")
                    .build()).build();

    private static final SdkField<String> SELF_SERVICE_ANSWER_GENERATION_AI_PROMPT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("selfServiceAnswerGenerationAIPromptId")
            .getter(getter(SelfServiceAIAgentConfiguration::selfServiceAnswerGenerationAIPromptId))
            .setter(setter(Builder::selfServiceAnswerGenerationAIPromptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("selfServiceAnswerGenerationAIPromptId").build()).build();

    private static final SdkField<String> SELF_SERVICE_AI_GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selfServiceAIGuardrailId").getter(getter(SelfServiceAIAgentConfiguration::selfServiceAIGuardrailId))
            .setter(setter(Builder::selfServiceAIGuardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selfServiceAIGuardrailId").build())
            .build();

    private static final SdkField<List<AssociationConfiguration>> ASSOCIATION_CONFIGURATIONS_FIELD = SdkField
            .<List<AssociationConfiguration>> builder(MarshallingType.LIST)
            .memberName("associationConfigurations")
            .getter(getter(SelfServiceAIAgentConfiguration::associationConfigurations))
            .setter(setter(Builder::associationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SELF_SERVICE_PRE_PROCESSING_AI_PROMPT_ID_FIELD, SELF_SERVICE_ANSWER_GENERATION_AI_PROMPT_ID_FIELD,
            SELF_SERVICE_AI_GUARDRAIL_ID_FIELD, ASSOCIATION_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String selfServicePreProcessingAIPromptId;

    private final String selfServiceAnswerGenerationAIPromptId;

    private final String selfServiceAIGuardrailId;

    private final List<AssociationConfiguration> associationConfigurations;

    private SelfServiceAIAgentConfiguration(BuilderImpl builder) {
        this.selfServicePreProcessingAIPromptId = builder.selfServicePreProcessingAIPromptId;
        this.selfServiceAnswerGenerationAIPromptId = builder.selfServiceAnswerGenerationAIPromptId;
        this.selfServiceAIGuardrailId = builder.selfServiceAIGuardrailId;
        this.associationConfigurations = builder.associationConfigurations;
    }

    /**
     * <p>
     * The AI Prompt identifier for the Self Service Pre-Processing prompt used by the SELF_SERVICE AI Agent
     * </p>
     * 
     * @return The AI Prompt identifier for the Self Service Pre-Processing prompt used by the SELF_SERVICE AI Agent
     */
    public final String selfServicePreProcessingAIPromptId() {
        return selfServicePreProcessingAIPromptId;
    }

    /**
     * <p>
     * The AI Prompt identifier for the Self Service Answer Generation prompt used by the SELF_SERVICE AI Agent
     * </p>
     * 
     * @return The AI Prompt identifier for the Self Service Answer Generation prompt used by the SELF_SERVICE AI Agent
     */
    public final String selfServiceAnswerGenerationAIPromptId() {
        return selfServiceAnswerGenerationAIPromptId;
    }

    /**
     * <p>
     * The AI Guardrail identifier used by the SELF_SERVICE AI Agent.
     * </p>
     * 
     * @return The AI Guardrail identifier used by the SELF_SERVICE AI Agent.
     */
    public final String selfServiceAIGuardrailId() {
        return selfServiceAIGuardrailId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociationConfigurations() {
        return associationConfigurations != null && !(associationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The association configurations for overriding behavior on this AI Agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationConfigurations} method.
     * </p>
     * 
     * @return The association configurations for overriding behavior on this AI Agent.
     */
    public final List<AssociationConfiguration> associationConfigurations() {
        return associationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selfServicePreProcessingAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(selfServiceAnswerGenerationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(selfServiceAIGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationConfigurations() ? associationConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfServiceAIAgentConfiguration)) {
            return false;
        }
        SelfServiceAIAgentConfiguration other = (SelfServiceAIAgentConfiguration) obj;
        return Objects.equals(selfServicePreProcessingAIPromptId(), other.selfServicePreProcessingAIPromptId())
                && Objects.equals(selfServiceAnswerGenerationAIPromptId(), other.selfServiceAnswerGenerationAIPromptId())
                && Objects.equals(selfServiceAIGuardrailId(), other.selfServiceAIGuardrailId())
                && hasAssociationConfigurations() == other.hasAssociationConfigurations()
                && Objects.equals(associationConfigurations(), other.associationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfServiceAIAgentConfiguration")
                .add("SelfServicePreProcessingAIPromptId", selfServicePreProcessingAIPromptId())
                .add("SelfServiceAnswerGenerationAIPromptId", selfServiceAnswerGenerationAIPromptId())
                .add("SelfServiceAIGuardrailId", selfServiceAIGuardrailId())
                .add("AssociationConfigurations", hasAssociationConfigurations() ? associationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "selfServicePreProcessingAIPromptId":
            return Optional.ofNullable(clazz.cast(selfServicePreProcessingAIPromptId()));
        case "selfServiceAnswerGenerationAIPromptId":
            return Optional.ofNullable(clazz.cast(selfServiceAnswerGenerationAIPromptId()));
        case "selfServiceAIGuardrailId":
            return Optional.ofNullable(clazz.cast(selfServiceAIGuardrailId()));
        case "associationConfigurations":
            return Optional.ofNullable(clazz.cast(associationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("selfServicePreProcessingAIPromptId", SELF_SERVICE_PRE_PROCESSING_AI_PROMPT_ID_FIELD);
        map.put("selfServiceAnswerGenerationAIPromptId", SELF_SERVICE_ANSWER_GENERATION_AI_PROMPT_ID_FIELD);
        map.put("selfServiceAIGuardrailId", SELF_SERVICE_AI_GUARDRAIL_ID_FIELD);
        map.put("associationConfigurations", ASSOCIATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelfServiceAIAgentConfiguration, T> g) {
        return obj -> g.apply((SelfServiceAIAgentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfServiceAIAgentConfiguration> {
        /**
         * <p>
         * The AI Prompt identifier for the Self Service Pre-Processing prompt used by the SELF_SERVICE AI Agent
         * </p>
         * 
         * @param selfServicePreProcessingAIPromptId
         *        The AI Prompt identifier for the Self Service Pre-Processing prompt used by the SELF_SERVICE AI Agent
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServicePreProcessingAIPromptId(String selfServicePreProcessingAIPromptId);

        /**
         * <p>
         * The AI Prompt identifier for the Self Service Answer Generation prompt used by the SELF_SERVICE AI Agent
         * </p>
         * 
         * @param selfServiceAnswerGenerationAIPromptId
         *        The AI Prompt identifier for the Self Service Answer Generation prompt used by the SELF_SERVICE AI
         *        Agent
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServiceAnswerGenerationAIPromptId(String selfServiceAnswerGenerationAIPromptId);

        /**
         * <p>
         * The AI Guardrail identifier used by the SELF_SERVICE AI Agent.
         * </p>
         * 
         * @param selfServiceAIGuardrailId
         *        The AI Guardrail identifier used by the SELF_SERVICE AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServiceAIGuardrailId(String selfServiceAIGuardrailId);

        /**
         * <p>
         * The association configurations for overriding behavior on this AI Agent.
         * </p>
         * 
         * @param associationConfigurations
         *        The association configurations for overriding behavior on this AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations);

        /**
         * <p>
         * The association configurations for overriding behavior on this AI Agent.
         * </p>
         * 
         * @param associationConfigurations
         *        The association configurations for overriding behavior on this AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationConfigurations(AssociationConfiguration... associationConfigurations);

        /**
         * <p>
         * The association configurations for overriding behavior on this AI Agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #associationConfigurations(List<AssociationConfiguration>)}.
         * 
         * @param associationConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AssociationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationConfigurations(java.util.Collection<AssociationConfiguration>)
         */
        Builder associationConfigurations(Consumer<AssociationConfiguration.Builder>... associationConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String selfServicePreProcessingAIPromptId;

        private String selfServiceAnswerGenerationAIPromptId;

        private String selfServiceAIGuardrailId;

        private List<AssociationConfiguration> associationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelfServiceAIAgentConfiguration model) {
            selfServicePreProcessingAIPromptId(model.selfServicePreProcessingAIPromptId);
            selfServiceAnswerGenerationAIPromptId(model.selfServiceAnswerGenerationAIPromptId);
            selfServiceAIGuardrailId(model.selfServiceAIGuardrailId);
            associationConfigurations(model.associationConfigurations);
        }

        public final String getSelfServicePreProcessingAIPromptId() {
            return selfServicePreProcessingAIPromptId;
        }

        public final void setSelfServicePreProcessingAIPromptId(String selfServicePreProcessingAIPromptId) {
            this.selfServicePreProcessingAIPromptId = selfServicePreProcessingAIPromptId;
        }

        @Override
        public final Builder selfServicePreProcessingAIPromptId(String selfServicePreProcessingAIPromptId) {
            this.selfServicePreProcessingAIPromptId = selfServicePreProcessingAIPromptId;
            return this;
        }

        public final String getSelfServiceAnswerGenerationAIPromptId() {
            return selfServiceAnswerGenerationAIPromptId;
        }

        public final void setSelfServiceAnswerGenerationAIPromptId(String selfServiceAnswerGenerationAIPromptId) {
            this.selfServiceAnswerGenerationAIPromptId = selfServiceAnswerGenerationAIPromptId;
        }

        @Override
        public final Builder selfServiceAnswerGenerationAIPromptId(String selfServiceAnswerGenerationAIPromptId) {
            this.selfServiceAnswerGenerationAIPromptId = selfServiceAnswerGenerationAIPromptId;
            return this;
        }

        public final String getSelfServiceAIGuardrailId() {
            return selfServiceAIGuardrailId;
        }

        public final void setSelfServiceAIGuardrailId(String selfServiceAIGuardrailId) {
            this.selfServiceAIGuardrailId = selfServiceAIGuardrailId;
        }

        @Override
        public final Builder selfServiceAIGuardrailId(String selfServiceAIGuardrailId) {
            this.selfServiceAIGuardrailId = selfServiceAIGuardrailId;
            return this;
        }

        public final List<AssociationConfiguration.Builder> getAssociationConfigurations() {
            List<AssociationConfiguration.Builder> result = AssociationConfigurationListCopier
                    .copyToBuilder(this.associationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationConfigurations(Collection<AssociationConfiguration.BuilderImpl> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copyFromBuilder(associationConfigurations);
        }

        @Override
        public final Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copy(associationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(AssociationConfiguration... associationConfigurations) {
            associationConfigurations(Arrays.asList(associationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(Consumer<AssociationConfiguration.Builder>... associationConfigurations) {
            associationConfigurations(Stream.of(associationConfigurations)
                    .map(c -> AssociationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SelfServiceAIAgentConfiguration build() {
            return new SelfServiceAIAgentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
