/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionData implements SdkPojo, Serializable, ToCopyableBuilder<SessionData.Builder, SessionData> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(SessionData::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(SessionData::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SessionData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SessionData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SessionData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SessionIntegrationConfiguration> INTEGRATION_CONFIGURATION_FIELD = SdkField
            .<SessionIntegrationConfiguration> builder(MarshallingType.SDK_POJO).memberName("integrationConfiguration")
            .getter(getter(SessionData::integrationConfiguration)).setter(setter(Builder::integrationConfiguration))
            .constructor(SessionIntegrationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationConfiguration").build())
            .build();

    private static final SdkField<TagFilter> TAG_FILTER_FIELD = SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tagFilter").getter(getter(SessionData::tagFilter)).setter(setter(Builder::tagFilter))
            .constructor(TagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilter").build()).build();

    private static final SdkField<Map<String, AIAgentConfigurationData>> AI_AGENT_CONFIGURATION_FIELD = SdkField
            .<Map<String, AIAgentConfigurationData>> builder(MarshallingType.MAP)
            .memberName("aiAgentConfiguration")
            .getter(getter(SessionData::aiAgentConfigurationAsStrings))
            .setter(setter(Builder::aiAgentConfigurationWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AIAgentConfigurationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(AIAgentConfigurationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("origin")
            .getter(getter(SessionData::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("origin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD,
            SESSION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, INTEGRATION_CONFIGURATION_FIELD, TAG_FILTER_FIELD,
            AI_AGENT_CONFIGURATION_FIELD, ORIGIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionArn;

    private final String sessionId;

    private final String name;

    private final String description;

    private final Map<String, String> tags;

    private final SessionIntegrationConfiguration integrationConfiguration;

    private final TagFilter tagFilter;

    private final Map<String, AIAgentConfigurationData> aiAgentConfiguration;

    private final String origin;

    private SessionData(BuilderImpl builder) {
        this.sessionArn = builder.sessionArn;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.integrationConfiguration = builder.integrationConfiguration;
        this.tagFilter = builder.tagFilter;
        this.aiAgentConfiguration = builder.aiAgentConfiguration;
        this.origin = builder.origin;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * The identifier of the session.
     * </p>
     * 
     * @return The identifier of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The name of the session.
     * </p>
     * 
     * @return The name of the session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the session.
     * </p>
     * 
     * @return The description of the session.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration information for the session integration.
     * </p>
     * 
     * @return The configuration information for the session integration.
     */
    public final SessionIntegrationConfiguration integrationConfiguration() {
        return integrationConfiguration;
    }

    /**
     * <p>
     * An object that can be used to specify Tag conditions.
     * </p>
     * 
     * @return An object that can be used to specify Tag conditions.
     */
    public final TagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q
     * in Connect for this Session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgentConfiguration} method.
     * </p>
     * 
     * @return The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
     *         Amazon Q in Connect for this Session.
     */
    public final Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration() {
        return AIAgentConfigurationMapCopier.copyStringToEnum(aiAgentConfiguration);
    }

    /**
     * For responses, this returns true if the service returned a value for the AiAgentConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAiAgentConfiguration() {
        return aiAgentConfiguration != null && !(aiAgentConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by Amazon Q
     * in Connect for this Session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgentConfiguration} method.
     * </p>
     * 
     * @return The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
     *         Amazon Q in Connect for this Session.
     */
    public final Map<String, AIAgentConfigurationData> aiAgentConfigurationAsStrings() {
        return aiAgentConfiguration;
    }

    /**
     * <p>
     * The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q in Connect
     * or <code>CUSTOMER</code> for a Session created by calling <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
     * >CreateSession</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q in
     *         Connect or <code>CUSTOMER</code> for a Session created by calling <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
     *         >CreateSession</a> API.
     * @see Origin
     */
    public final Origin origin() {
        return Origin.fromValue(origin);
    }

    /**
     * <p>
     * The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q in Connect
     * or <code>CUSTOMER</code> for a Session created by calling <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
     * >CreateSession</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link Origin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q in
     *         Connect or <code>CUSTOMER</code> for a Session created by calling <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
     *         >CreateSession</a> API.
     * @see Origin
     */
    public final String originAsString() {
        return origin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(integrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasAiAgentConfiguration() ? aiAgentConfigurationAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionData)) {
            return false;
        }
        SessionData other = (SessionData) obj;
        return Objects.equals(sessionArn(), other.sessionArn()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(integrationConfiguration(), other.integrationConfiguration())
                && Objects.equals(tagFilter(), other.tagFilter()) && hasAiAgentConfiguration() == other.hasAiAgentConfiguration()
                && Objects.equals(aiAgentConfigurationAsStrings(), other.aiAgentConfigurationAsStrings())
                && Objects.equals(originAsString(), other.originAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionData").add("SessionArn", sessionArn()).add("SessionId", sessionId()).add("Name", name())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("IntegrationConfiguration", integrationConfiguration()).add("TagFilter", tagFilter())
                .add("AiAgentConfiguration", hasAiAgentConfiguration() ? aiAgentConfigurationAsStrings() : null)
                .add("Origin", originAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "integrationConfiguration":
            return Optional.ofNullable(clazz.cast(integrationConfiguration()));
        case "tagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "aiAgentConfiguration":
            return Optional.ofNullable(clazz.cast(aiAgentConfigurationAsStrings()));
        case "origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("integrationConfiguration", INTEGRATION_CONFIGURATION_FIELD);
        map.put("tagFilter", TAG_FILTER_FIELD);
        map.put("aiAgentConfiguration", AI_AGENT_CONFIGURATION_FIELD);
        map.put("origin", ORIGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionData, T> g) {
        return obj -> g.apply((SessionData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionData> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The identifier of the session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The name of the session.
         * </p>
         * 
         * @param name
         *        The name of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the session.
         * </p>
         * 
         * @param description
         *        The description of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The configuration information for the session integration.
         * </p>
         * 
         * @param integrationConfiguration
         *        The configuration information for the session integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationConfiguration(SessionIntegrationConfiguration integrationConfiguration);

        /**
         * <p>
         * The configuration information for the session integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionIntegrationConfiguration.Builder}
         * avoiding the need to create one manually via {@link SessionIntegrationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionIntegrationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #integrationConfiguration(SessionIntegrationConfiguration)}.
         * 
         * @param integrationConfiguration
         *        a consumer that will call methods on {@link SessionIntegrationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrationConfiguration(SessionIntegrationConfiguration)
         */
        default Builder integrationConfiguration(Consumer<SessionIntegrationConfiguration.Builder> integrationConfiguration) {
            return integrationConfiguration(SessionIntegrationConfiguration.builder().applyMutation(integrationConfiguration)
                    .build());
        }

        /**
         * <p>
         * An object that can be used to specify Tag conditions.
         * </p>
         * 
         * @param tagFilter
         *        An object that can be used to specify Tag conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(TagFilter tagFilter);

        /**
         * <p>
         * An object that can be used to specify Tag conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagFilter.Builder} avoiding the need to
         * create one manually via {@link TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tagFilter(TagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(TagFilter)
         */
        default Builder tagFilter(Consumer<TagFilter.Builder> tagFilter) {
            return tagFilter(TagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
         * Amazon Q in Connect for this Session.
         * </p>
         * 
         * @param aiAgentConfiguration
         *        The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used
         *        by Amazon Q in Connect for this Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration);

        /**
         * <p>
         * The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used by
         * Amazon Q in Connect for this Session.
         * </p>
         * 
         * @param aiAgentConfiguration
         *        The configuration of the AI Agents (mapped by AI Agent Type to AI Agent version) that should be used
         *        by Amazon Q in Connect for this Session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration);

        /**
         * <p>
         * The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q in
         * Connect or <code>CUSTOMER</code> for a Session created by calling <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
         * >CreateSession</a> API.
         * </p>
         * 
         * @param origin
         *        The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q
         *        in Connect or <code>CUSTOMER</code> for a Session created by calling <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
         *        >CreateSession</a> API.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(String origin);

        /**
         * <p>
         * The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q in
         * Connect or <code>CUSTOMER</code> for a Session created by calling <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
         * >CreateSession</a> API.
         * </p>
         * 
         * @param origin
         *        The origin of the Session to be listed. <code>SYSTEM</code> for a default Session created by Amazon Q
         *        in Connect or <code>CUSTOMER</code> for a Session created by calling <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_CreateSession.html"
         *        >CreateSession</a> API.
         * @see Origin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Origin
         */
        Builder origin(Origin origin);
    }

    static final class BuilderImpl implements Builder {
        private String sessionArn;

        private String sessionId;

        private String name;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private SessionIntegrationConfiguration integrationConfiguration;

        private TagFilter tagFilter;

        private Map<String, AIAgentConfigurationData> aiAgentConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String origin;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionData model) {
            sessionArn(model.sessionArn);
            sessionId(model.sessionId);
            name(model.name);
            description(model.description);
            tags(model.tags);
            integrationConfiguration(model.integrationConfiguration);
            tagFilter(model.tagFilter);
            aiAgentConfigurationWithStrings(model.aiAgentConfiguration);
            origin(model.origin);
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final SessionIntegrationConfiguration.Builder getIntegrationConfiguration() {
            return integrationConfiguration != null ? integrationConfiguration.toBuilder() : null;
        }

        public final void setIntegrationConfiguration(SessionIntegrationConfiguration.BuilderImpl integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration != null ? integrationConfiguration.build() : null;
        }

        @Override
        public final Builder integrationConfiguration(SessionIntegrationConfiguration integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration;
            return this;
        }

        public final TagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(TagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(TagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final Map<String, AIAgentConfigurationData.Builder> getAiAgentConfiguration() {
            Map<String, AIAgentConfigurationData.Builder> result = AIAgentConfigurationMapCopier
                    .copyToBuilder(this.aiAgentConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAiAgentConfiguration(Map<String, AIAgentConfigurationData.BuilderImpl> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyFromBuilder(aiAgentConfiguration);
        }

        @Override
        public final Builder aiAgentConfigurationWithStrings(Map<String, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copy(aiAgentConfiguration);
            return this;
        }

        @Override
        public final Builder aiAgentConfiguration(Map<AIAgentType, AIAgentConfigurationData> aiAgentConfiguration) {
            this.aiAgentConfiguration = AIAgentConfigurationMapCopier.copyEnumToString(aiAgentConfiguration);
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        @Override
        public SessionData build() {
            return new SessionData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
