/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionSummary implements SdkPojo, Serializable, ToCopyableBuilder<SessionSummary.Builder, SessionSummary> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(SessionSummary::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(SessionSummary::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(SessionSummary::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(SessionSummary::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            SESSION_ARN_FIELD, ASSISTANT_ID_FIELD, ASSISTANT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionId;

    private final String sessionArn;

    private final String assistantId;

    private final String assistantArn;

    private SessionSummary(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.assistantId = builder.assistantId;
        this.assistantArn = builder.assistantArn;
    }

    /**
     * <p>
     * The identifier of the session.
     * </p>
     * 
     * @return The identifier of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSummary)) {
            return false;
        }
        SessionSummary other = (SessionSummary) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(sessionArn(), other.sessionArn())
                && Objects.equals(assistantId(), other.assistantId()) && Objects.equals(assistantArn(), other.assistantArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionSummary").add("SessionId", sessionId()).add("SessionArn", sessionArn())
                .add("AssistantId", assistantId()).add("AssistantArn", assistantArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionSummary, T> g) {
        return obj -> g.apply((SessionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionSummary> {
        /**
         * <p>
         * The identifier of the session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);
    }

    static final class BuilderImpl implements Builder {
        private String sessionId;

        private String sessionArn;

        private String assistantId;

        private String assistantArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionSummary model) {
            sessionId(model.sessionId);
            sessionArn(model.sessionArn);
            assistantId(model.assistantId);
            assistantArn(model.assistantArn);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        @Override
        public SessionSummary build() {
            return new SessionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
