/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the source content data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceContentDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceContentDataDetails.Builder, SourceContentDataDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SourceContentDataDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SourceContentDataDetails::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<TextData> TEXT_DATA_FIELD = SdkField.<TextData> builder(MarshallingType.SDK_POJO)
            .memberName("textData").getter(getter(SourceContentDataDetails::textData)).setter(setter(Builder::textData))
            .constructor(TextData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textData").build()).build();

    private static final SdkField<RankingData> RANKING_DATA_FIELD = SdkField.<RankingData> builder(MarshallingType.SDK_POJO)
            .memberName("rankingData").getter(getter(SourceContentDataDetails::rankingData)).setter(setter(Builder::rankingData))
            .constructor(RankingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rankingData").build()).build();

    private static final SdkField<CitationSpan> CITATION_SPAN_FIELD = SdkField.<CitationSpan> builder(MarshallingType.SDK_POJO)
            .memberName("citationSpan").getter(getter(SourceContentDataDetails::citationSpan))
            .setter(setter(Builder::citationSpan)).constructor(CitationSpan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citationSpan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            TEXT_DATA_FIELD, RANKING_DATA_FIELD, CITATION_SPAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final TextData textData;

    private final RankingData rankingData;

    private final CitationSpan citationSpan;

    private SourceContentDataDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.textData = builder.textData;
        this.rankingData = builder.rankingData;
        this.citationSpan = builder.citationSpan;
    }

    /**
     * <p>
     * The identifier of the source content.
     * </p>
     * 
     * @return The identifier of the source content.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the source content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source content.
     * @see SourceContentType
     */
    public final SourceContentType type() {
        return SourceContentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the source content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source content.
     * @see SourceContentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details about the source content text data.
     * </p>
     * 
     * @return Details about the source content text data.
     */
    public final TextData textData() {
        return textData;
    }

    /**
     * <p>
     * Details about the source content ranking data.
     * </p>
     * 
     * @return Details about the source content ranking data.
     */
    public final RankingData rankingData() {
        return rankingData;
    }

    /**
     * <p>
     * Contains information about where the text with a citation begins and ends in the generated output.
     * </p>
     * 
     * @return Contains information about where the text with a citation begins and ends in the generated output.
     */
    public final CitationSpan citationSpan() {
        return citationSpan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(textData());
        hashCode = 31 * hashCode + Objects.hashCode(rankingData());
        hashCode = 31 * hashCode + Objects.hashCode(citationSpan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceContentDataDetails)) {
            return false;
        }
        SourceContentDataDetails other = (SourceContentDataDetails) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(textData(), other.textData()) && Objects.equals(rankingData(), other.rankingData())
                && Objects.equals(citationSpan(), other.citationSpan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceContentDataDetails").add("Id", id()).add("Type", typeAsString())
                .add("TextData", textData()).add("RankingData", rankingData()).add("CitationSpan", citationSpan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "textData":
            return Optional.ofNullable(clazz.cast(textData()));
        case "rankingData":
            return Optional.ofNullable(clazz.cast(rankingData()));
        case "citationSpan":
            return Optional.ofNullable(clazz.cast(citationSpan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("textData", TEXT_DATA_FIELD);
        map.put("rankingData", RANKING_DATA_FIELD);
        map.put("citationSpan", CITATION_SPAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceContentDataDetails, T> g) {
        return obj -> g.apply((SourceContentDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceContentDataDetails> {
        /**
         * <p>
         * The identifier of the source content.
         * </p>
         * 
         * @param id
         *        The identifier of the source content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the source content.
         * </p>
         * 
         * @param type
         *        The type of the source content.
         * @see SourceContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceContentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the source content.
         * </p>
         * 
         * @param type
         *        The type of the source content.
         * @see SourceContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceContentType
         */
        Builder type(SourceContentType type);

        /**
         * <p>
         * Details about the source content text data.
         * </p>
         * 
         * @param textData
         *        Details about the source content text data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textData(TextData textData);

        /**
         * <p>
         * Details about the source content text data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextData.Builder} avoiding the need to
         * create one manually via {@link TextData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextData.Builder#build()} is called immediately and its result is
         * passed to {@link #textData(TextData)}.
         * 
         * @param textData
         *        a consumer that will call methods on {@link TextData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textData(TextData)
         */
        default Builder textData(Consumer<TextData.Builder> textData) {
            return textData(TextData.builder().applyMutation(textData).build());
        }

        /**
         * <p>
         * Details about the source content ranking data.
         * </p>
         * 
         * @param rankingData
         *        Details about the source content ranking data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rankingData(RankingData rankingData);

        /**
         * <p>
         * Details about the source content ranking data.
         * </p>
         * This is a convenience method that creates an instance of the {@link RankingData.Builder} avoiding the need to
         * create one manually via {@link RankingData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RankingData.Builder#build()} is called immediately and its result
         * is passed to {@link #rankingData(RankingData)}.
         * 
         * @param rankingData
         *        a consumer that will call methods on {@link RankingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rankingData(RankingData)
         */
        default Builder rankingData(Consumer<RankingData.Builder> rankingData) {
            return rankingData(RankingData.builder().applyMutation(rankingData).build());
        }

        /**
         * <p>
         * Contains information about where the text with a citation begins and ends in the generated output.
         * </p>
         * 
         * @param citationSpan
         *        Contains information about where the text with a citation begins and ends in the generated output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citationSpan(CitationSpan citationSpan);

        /**
         * <p>
         * Contains information about where the text with a citation begins and ends in the generated output.
         * </p>
         * This is a convenience method that creates an instance of the {@link CitationSpan.Builder} avoiding the need
         * to create one manually via {@link CitationSpan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CitationSpan.Builder#build()} is called immediately and its
         * result is passed to {@link #citationSpan(CitationSpan)}.
         * 
         * @param citationSpan
         *        a consumer that will call methods on {@link CitationSpan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citationSpan(CitationSpan)
         */
        default Builder citationSpan(Consumer<CitationSpan.Builder> citationSpan) {
            return citationSpan(CitationSpan.builder().applyMutation(citationSpan).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private TextData textData;

        private RankingData rankingData;

        private CitationSpan citationSpan;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceContentDataDetails model) {
            id(model.id);
            type(model.type);
            textData(model.textData);
            rankingData(model.rankingData);
            citationSpan(model.citationSpan);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TextData.Builder getTextData() {
            return textData != null ? textData.toBuilder() : null;
        }

        public final void setTextData(TextData.BuilderImpl textData) {
            this.textData = textData != null ? textData.build() : null;
        }

        @Override
        public final Builder textData(TextData textData) {
            this.textData = textData;
            return this;
        }

        public final RankingData.Builder getRankingData() {
            return rankingData != null ? rankingData.toBuilder() : null;
        }

        public final void setRankingData(RankingData.BuilderImpl rankingData) {
            this.rankingData = rankingData != null ? rankingData.build() : null;
        }

        @Override
        public final Builder rankingData(RankingData rankingData) {
            this.rankingData = rankingData;
            return this;
        }

        public final CitationSpan.Builder getCitationSpan() {
            return citationSpan != null ? citationSpan.toBuilder() : null;
        }

        public final void setCitationSpan(CitationSpan.BuilderImpl citationSpan) {
            this.citationSpan = citationSpan != null ? citationSpan.build() : null;
        }

        @Override
        public final Builder citationSpan(CitationSpan citationSpan) {
            this.citationSpan = citationSpan;
            return this;
        }

        @Override
        public SourceContentDataDetails build() {
            return new SourceContentDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
