/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a ledger, including its name, state, and when it was created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LedgerSummary implements SdkPojo, Serializable, ToCopyableBuilder<LedgerSummary.Builder, LedgerSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LedgerSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LedgerSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LedgerSummary::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATE_FIELD,
            CREATION_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String state;

    private final Instant creationDateTime;

    private LedgerSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LedgerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current status of the ledger.
     * @see LedgerState
     */
    public LedgerState state() {
        return LedgerState.fromValue(state);
    }

    /**
     * <p>
     * The current status of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LedgerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current status of the ledger.
     * @see LedgerState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of seconds
     * elapsed since 12:00:00 AM January 1, 1970 UTC.)
     * </p>
     * 
     * @return The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of
     *         seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    public Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LedgerSummary)) {
            return false;
        }
        LedgerSummary other = (LedgerSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LedgerSummary").add("Name", name()).add("State", stateAsString())
                .add("CreationDateTime", creationDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LedgerSummary, T> g) {
        return obj -> g.apply((LedgerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LedgerSummary> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param name
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the ledger.
         * </p>
         * 
         * @param state
         *        The current status of the ledger.
         * @see LedgerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LedgerState
         */
        Builder state(String state);

        /**
         * <p>
         * The current status of the ledger.
         * </p>
         * 
         * @param state
         *        The current status of the ledger.
         * @see LedgerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LedgerState
         */
        Builder state(LedgerState state);

        /**
         * <p>
         * The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of
         * seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * </p>
         * 
         * @param creationDateTime
         *        The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number
         *        of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String state;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LedgerSummary model) {
            name(model.name);
            state(model.state);
            creationDateTime(model.creationDateTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(LedgerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public LedgerSummary build() {
            return new LedgerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
