/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.ErrorCause;
import software.amazon.awssdk.services.qldb.model.KinesisConfiguration;
import software.amazon.awssdk.services.qldb.model.StreamStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JournalKinesisStreamDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JournalKinesisStreamDescription> {
    private static final SdkField<String> LEDGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::ledgerName)).setter(JournalKinesisStreamDescription.setter(Builder::ledgerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LedgerName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::creationTime)).setter(JournalKinesisStreamDescription.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::inclusiveStartTime)).setter(JournalKinesisStreamDescription.setter(Builder::inclusiveStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build()}).build();
    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::exclusiveEndTime)).setter(JournalKinesisStreamDescription.setter(Builder::exclusiveEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::roleArn)).setter(JournalKinesisStreamDescription.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::streamId)).setter(JournalKinesisStreamDescription.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::arn)).setter(JournalKinesisStreamDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::statusAsString)).setter(JournalKinesisStreamDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<KinesisConfiguration> KINESIS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::kinesisConfiguration)).setter(JournalKinesisStreamDescription.setter(Builder::kinesisConfiguration)).constructor(KinesisConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisConfiguration").build()}).build();
    private static final SdkField<String> ERROR_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::errorCauseAsString)).setter(JournalKinesisStreamDescription.setter(Builder::errorCause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCause").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JournalKinesisStreamDescription.getter(JournalKinesisStreamDescription::streamName)).setter(JournalKinesisStreamDescription.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGER_NAME_FIELD, CREATION_TIME_FIELD, INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD, ROLE_ARN_FIELD, STREAM_ID_FIELD, ARN_FIELD, STATUS_FIELD, KINESIS_CONFIGURATION_FIELD, ERROR_CAUSE_FIELD, STREAM_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ledgerName;
    private final Instant creationTime;
    private final Instant inclusiveStartTime;
    private final Instant exclusiveEndTime;
    private final String roleArn;
    private final String streamId;
    private final String arn;
    private final String status;
    private final KinesisConfiguration kinesisConfiguration;
    private final String errorCause;
    private final String streamName;

    private JournalKinesisStreamDescription(BuilderImpl builder) {
        this.ledgerName = builder.ledgerName;
        this.creationTime = builder.creationTime;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.roleArn = builder.roleArn;
        this.streamId = builder.streamId;
        this.arn = builder.arn;
        this.status = builder.status;
        this.kinesisConfiguration = builder.kinesisConfiguration;
        this.errorCause = builder.errorCause;
        this.streamName = builder.streamName;
    }

    public String ledgerName() {
        return this.ledgerName;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant inclusiveStartTime() {
        return this.inclusiveStartTime;
    }

    public Instant exclusiveEndTime() {
        return this.exclusiveEndTime;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String streamId() {
        return this.streamId;
    }

    public String arn() {
        return this.arn;
    }

    public StreamStatus status() {
        return StreamStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public KinesisConfiguration kinesisConfiguration() {
        return this.kinesisConfiguration;
    }

    public ErrorCause errorCause() {
        return ErrorCause.fromValue(this.errorCause);
    }

    public String errorCauseAsString() {
        return this.errorCause;
    }

    public String streamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ledgerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCauseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JournalKinesisStreamDescription)) {
            return false;
        }
        JournalKinesisStreamDescription other = (JournalKinesisStreamDescription)obj;
        return Objects.equals(this.ledgerName(), other.ledgerName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.inclusiveStartTime(), other.inclusiveStartTime()) && Objects.equals(this.exclusiveEndTime(), other.exclusiveEndTime()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.kinesisConfiguration(), other.kinesisConfiguration()) && Objects.equals(this.errorCauseAsString(), other.errorCauseAsString()) && Objects.equals(this.streamName(), other.streamName());
    }

    public String toString() {
        return ToString.builder((String)"JournalKinesisStreamDescription").add("LedgerName", (Object)this.ledgerName()).add("CreationTime", (Object)this.creationTime()).add("InclusiveStartTime", (Object)this.inclusiveStartTime()).add("ExclusiveEndTime", (Object)this.exclusiveEndTime()).add("RoleArn", (Object)this.roleArn()).add("StreamId", (Object)this.streamId()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("KinesisConfiguration", (Object)this.kinesisConfiguration()).add("ErrorCause", (Object)this.errorCauseAsString()).add("StreamName", (Object)this.streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LedgerName": {
                return Optional.ofNullable(clazz.cast(this.ledgerName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "InclusiveStartTime": {
                return Optional.ofNullable(clazz.cast(this.inclusiveStartTime()));
            }
            case "ExclusiveEndTime": {
                return Optional.ofNullable(clazz.cast(this.exclusiveEndTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "KinesisConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisConfiguration()));
            }
            case "ErrorCause": {
                return Optional.ofNullable(clazz.cast(this.errorCauseAsString()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JournalKinesisStreamDescription, T> g) {
        return obj -> g.apply((JournalKinesisStreamDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ledgerName;
        private Instant creationTime;
        private Instant inclusiveStartTime;
        private Instant exclusiveEndTime;
        private String roleArn;
        private String streamId;
        private String arn;
        private String status;
        private KinesisConfiguration kinesisConfiguration;
        private String errorCause;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(JournalKinesisStreamDescription model) {
            this.ledgerName(model.ledgerName);
            this.creationTime(model.creationTime);
            this.inclusiveStartTime(model.inclusiveStartTime);
            this.exclusiveEndTime(model.exclusiveEndTime);
            this.roleArn(model.roleArn);
            this.streamId(model.streamId);
            this.arn(model.arn);
            this.status(model.status);
            this.kinesisConfiguration(model.kinesisConfiguration);
            this.errorCause(model.errorCause);
            this.streamName(model.streamName);
        }

        public final String getLedgerName() {
            return this.ledgerName;
        }

        @Override
        public final Builder ledgerName(String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        public final void setLedgerName(String ledgerName) {
            this.ledgerName = ledgerName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getInclusiveStartTime() {
            return this.inclusiveStartTime;
        }

        @Override
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        public final Instant getExclusiveEndTime() {
            return this.exclusiveEndTime;
        }

        @Override
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final KinesisConfiguration.Builder getKinesisConfiguration() {
            return this.kinesisConfiguration != null ? this.kinesisConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kinesisConfiguration(KinesisConfiguration kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration;
            return this;
        }

        public final void setKinesisConfiguration(KinesisConfiguration.BuilderImpl kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration != null ? kinesisConfiguration.build() : null;
        }

        public final String getErrorCause() {
            return this.errorCause;
        }

        @Override
        public final Builder errorCause(String errorCause) {
            this.errorCause = errorCause;
            return this;
        }

        @Override
        public final Builder errorCause(ErrorCause errorCause) {
            this.errorCause(errorCause == null ? null : errorCause.toString());
            return this;
        }

        public final void setErrorCause(String errorCause) {
            this.errorCause = errorCause;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public JournalKinesisStreamDescription build() {
            return new JournalKinesisStreamDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JournalKinesisStreamDescription> {
        public Builder ledgerName(String var1);

        public Builder creationTime(Instant var1);

        public Builder inclusiveStartTime(Instant var1);

        public Builder exclusiveEndTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder streamId(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(StreamStatus var1);

        public Builder kinesisConfiguration(KinesisConfiguration var1);

        default public Builder kinesisConfiguration(Consumer<KinesisConfiguration.Builder> kinesisConfiguration) {
            return this.kinesisConfiguration((KinesisConfiguration)((KinesisConfiguration.Builder)KinesisConfiguration.builder().applyMutation(kinesisConfiguration)).build());
        }

        public Builder errorCause(String var1);

        public Builder errorCause(ErrorCause var1);

        public Builder streamName(String var1);
    }
}

