/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDigestResponse extends QldbResponse implements
        ToCopyableBuilder<GetDigestResponse.Builder, GetDigestResponse> {
    private static final SdkField<SdkBytes> DIGEST_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(GetDigestResponse::digest)).setter(setter(Builder::digest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Digest").build()).build();

    private static final SdkField<ValueHolder> DIGEST_TIP_ADDRESS_FIELD = SdkField
            .<ValueHolder> builder(MarshallingType.SDK_POJO).getter(getter(GetDigestResponse::digestTipAddress))
            .setter(setter(Builder::digestTipAddress)).constructor(ValueHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestTipAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIGEST_FIELD,
            DIGEST_TIP_ADDRESS_FIELD));

    private final SdkBytes digest;

    private final ValueHolder digestTipAddress;

    private GetDigestResponse(BuilderImpl builder) {
        super(builder);
        this.digest = builder.digest;
        this.digestTipAddress = builder.digestTipAddress;
    }

    /**
     * <p>
     * The 256-bit hash value representing the digest returned by a <code>GetDigest</code> request.
     * </p>
     * 
     * @return The 256-bit hash value representing the digest returned by a <code>GetDigest</code> request.
     */
    public SdkBytes digest() {
        return digest;
    }

    /**
     * <p>
     * The latest block location covered by the digest that you requested. An address is an Amazon Ion structure that
     * has two fields: <code>strandId</code> and <code>sequenceNo</code>.
     * </p>
     * 
     * @return The latest block location covered by the digest that you requested. An address is an Amazon Ion structure
     *         that has two fields: <code>strandId</code> and <code>sequenceNo</code>.
     */
    public ValueHolder digestTipAddress() {
        return digestTipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(digest());
        hashCode = 31 * hashCode + Objects.hashCode(digestTipAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDigestResponse)) {
            return false;
        }
        GetDigestResponse other = (GetDigestResponse) obj;
        return Objects.equals(digest(), other.digest()) && Objects.equals(digestTipAddress(), other.digestTipAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDigestResponse").add("Digest", digest())
                .add("DigestTipAddress", digestTipAddress() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Digest":
            return Optional.ofNullable(clazz.cast(digest()));
        case "DigestTipAddress":
            return Optional.ofNullable(clazz.cast(digestTipAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDigestResponse, T> g) {
        return obj -> g.apply((GetDigestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDigestResponse> {
        /**
         * <p>
         * The 256-bit hash value representing the digest returned by a <code>GetDigest</code> request.
         * </p>
         * 
         * @param digest
         *        The 256-bit hash value representing the digest returned by a <code>GetDigest</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digest(SdkBytes digest);

        /**
         * <p>
         * The latest block location covered by the digest that you requested. An address is an Amazon Ion structure
         * that has two fields: <code>strandId</code> and <code>sequenceNo</code>.
         * </p>
         * 
         * @param digestTipAddress
         *        The latest block location covered by the digest that you requested. An address is an Amazon Ion
         *        structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digestTipAddress(ValueHolder digestTipAddress);

        /**
         * <p>
         * The latest block location covered by the digest that you requested. An address is an Amazon Ion structure
         * that has two fields: <code>strandId</code> and <code>sequenceNo</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ValueHolder.Builder} avoiding the need to create
         * one manually via {@link ValueHolder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValueHolder.Builder#build()} is called immediately and its result
         * is passed to {@link #digestTipAddress(ValueHolder)}.
         * 
         * @param digestTipAddress
         *        a consumer that will call methods on {@link ValueHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #digestTipAddress(ValueHolder)
         */
        default Builder digestTipAddress(Consumer<ValueHolder.Builder> digestTipAddress) {
            return digestTipAddress(ValueHolder.builder().applyMutation(digestTipAddress).build());
        }
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private SdkBytes digest;

        private ValueHolder digestTipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDigestResponse model) {
            super(model);
            digest(model.digest);
            digestTipAddress(model.digestTipAddress);
        }

        public final ByteBuffer getDigest() {
            return digest == null ? null : digest.asByteBuffer();
        }

        @Override
        public final Builder digest(SdkBytes digest) {
            this.digest = StandardMemberCopier.copy(digest);
            return this;
        }

        public final void setDigest(ByteBuffer digest) {
            digest(digest == null ? null : SdkBytes.fromByteBuffer(digest));
        }

        public final ValueHolder.Builder getDigestTipAddress() {
            return digestTipAddress != null ? digestTipAddress.toBuilder() : null;
        }

        @Override
        public final Builder digestTipAddress(ValueHolder digestTipAddress) {
            this.digestTipAddress = digestTipAddress;
            return this;
        }

        public final void setDigestTipAddress(ValueHolder.BuilderImpl digestTipAddress) {
            this.digestTipAddress = digestTipAddress != null ? digestTipAddress.build() : null;
        }

        @Override
        public GetDigestResponse build() {
            return new GetDigestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
