/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.services.qldb.model.ValueHolder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlockResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, GetBlockResponse> {
    private static final SdkField<ValueHolder> BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Block").getter(GetBlockResponse.getter(GetBlockResponse::block)).setter(GetBlockResponse.setter(Builder::block)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()}).build();
    private static final SdkField<ValueHolder> PROOF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Proof").getter(GetBlockResponse.getter(GetBlockResponse::proof)).setter(GetBlockResponse.setter(Builder::proof)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proof").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_FIELD, PROOF_FIELD));
    private final ValueHolder block;
    private final ValueHolder proof;

    private GetBlockResponse(BuilderImpl builder) {
        super(builder);
        this.block = builder.block;
        this.proof = builder.proof;
    }

    public ValueHolder block() {
        return this.block;
    }

    public ValueHolder proof() {
        return this.proof;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.block());
        hashCode = 31 * hashCode + Objects.hashCode(this.proof());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlockResponse)) {
            return false;
        }
        GetBlockResponse other = (GetBlockResponse)((Object)obj);
        return Objects.equals(this.block(), other.block()) && Objects.equals(this.proof(), other.proof());
    }

    public String toString() {
        return ToString.builder((String)"GetBlockResponse").add("Block", (Object)(this.block() == null ? null : "*** Sensitive Data Redacted ***")).add("Proof", (Object)(this.proof() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Block": {
                return Optional.ofNullable(clazz.cast(this.block()));
            }
            case "Proof": {
                return Optional.ofNullable(clazz.cast(this.proof()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlockResponse, T> g) {
        return obj -> g.apply((GetBlockResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private ValueHolder block;
        private ValueHolder proof;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlockResponse model) {
            super(model);
            this.block(model.block);
            this.proof(model.proof);
        }

        public final ValueHolder.Builder getBlock() {
            return this.block != null ? this.block.toBuilder() : null;
        }

        @Override
        public final Builder block(ValueHolder block) {
            this.block = block;
            return this;
        }

        public final void setBlock(ValueHolder.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        public final ValueHolder.Builder getProof() {
            return this.proof != null ? this.proof.toBuilder() : null;
        }

        @Override
        public final Builder proof(ValueHolder proof) {
            this.proof = proof;
            return this;
        }

        public final void setProof(ValueHolder.BuilderImpl proof) {
            this.proof = proof != null ? proof.build() : null;
        }

        @Override
        public GetBlockResponse build() {
            return new GetBlockResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlockResponse> {
        public Builder block(ValueHolder var1);

        default public Builder block(Consumer<ValueHolder.Builder> block) {
            return this.block((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(block)).build());
        }

        public Builder proof(ValueHolder var1);

        default public Builder proof(Consumer<ValueHolder.Builder> proof) {
            return this.proof((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(proof)).build());
        }
    }
}

