/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJournalKinesisStreamResponse extends QldbResponse implements
        ToCopyableBuilder<DescribeJournalKinesisStreamResponse.Builder, DescribeJournalKinesisStreamResponse> {
    private static final SdkField<JournalKinesisStreamDescription> STREAM_FIELD = SdkField
            .<JournalKinesisStreamDescription> builder(MarshallingType.SDK_POJO).memberName("Stream")
            .getter(getter(DescribeJournalKinesisStreamResponse::stream)).setter(setter(Builder::stream))
            .constructor(JournalKinesisStreamDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_FIELD));

    private final JournalKinesisStreamDescription stream;

    private DescribeJournalKinesisStreamResponse(BuilderImpl builder) {
        super(builder);
        this.stream = builder.stream;
    }

    /**
     * <p>
     * Information about the QLDB journal stream returned by a <code>DescribeJournalS3Export</code> request.
     * </p>
     * 
     * @return Information about the QLDB journal stream returned by a <code>DescribeJournalS3Export</code> request.
     */
    public JournalKinesisStreamDescription stream() {
        return stream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stream());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJournalKinesisStreamResponse)) {
            return false;
        }
        DescribeJournalKinesisStreamResponse other = (DescribeJournalKinesisStreamResponse) obj;
        return Objects.equals(stream(), other.stream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeJournalKinesisStreamResponse").add("Stream", stream()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stream":
            return Optional.ofNullable(clazz.cast(stream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJournalKinesisStreamResponse, T> g) {
        return obj -> g.apply((DescribeJournalKinesisStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeJournalKinesisStreamResponse> {
        /**
         * <p>
         * Information about the QLDB journal stream returned by a <code>DescribeJournalS3Export</code> request.
         * </p>
         * 
         * @param stream
         *        Information about the QLDB journal stream returned by a <code>DescribeJournalS3Export</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stream(JournalKinesisStreamDescription stream);

        /**
         * <p>
         * Information about the QLDB journal stream returned by a <code>DescribeJournalS3Export</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link JournalKinesisStreamDescription.Builder}
         * avoiding the need to create one manually via {@link JournalKinesisStreamDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link JournalKinesisStreamDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #stream(JournalKinesisStreamDescription)}.
         * 
         * @param stream
         *        a consumer that will call methods on {@link JournalKinesisStreamDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stream(JournalKinesisStreamDescription)
         */
        default Builder stream(Consumer<JournalKinesisStreamDescription.Builder> stream) {
            return stream(JournalKinesisStreamDescription.builder().applyMutation(stream).build());
        }
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private JournalKinesisStreamDescription stream;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJournalKinesisStreamResponse model) {
            super(model);
            stream(model.stream);
        }

        public final JournalKinesisStreamDescription.Builder getStream() {
            return stream != null ? stream.toBuilder() : null;
        }

        @Override
        public final Builder stream(JournalKinesisStreamDescription stream) {
            this.stream = stream;
            return this;
        }

        public final void setStream(JournalKinesisStreamDescription.BuilderImpl stream) {
            this.stream = stream != null ? stream.build() : null;
        }

        @Override
        public DescribeJournalKinesisStreamResponse build() {
            return new DescribeJournalKinesisStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
