/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlockRequest extends QldbRequest implements ToCopyableBuilder<GetBlockRequest.Builder, GetBlockRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetBlockRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<ValueHolder> BLOCK_ADDRESS_FIELD = SdkField.<ValueHolder> builder(MarshallingType.SDK_POJO)
            .memberName("BlockAddress").getter(getter(GetBlockRequest::blockAddress)).setter(setter(Builder::blockAddress))
            .constructor(ValueHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockAddress").build()).build();

    private static final SdkField<ValueHolder> DIGEST_TIP_ADDRESS_FIELD = SdkField
            .<ValueHolder> builder(MarshallingType.SDK_POJO).memberName("DigestTipAddress")
            .getter(getter(GetBlockRequest::digestTipAddress)).setter(setter(Builder::digestTipAddress))
            .constructor(ValueHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestTipAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            BLOCK_ADDRESS_FIELD, DIGEST_TIP_ADDRESS_FIELD));

    private final String name;

    private final ValueHolder blockAddress;

    private final ValueHolder digestTipAddress;

    private GetBlockRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.blockAddress = builder.blockAddress;
        this.digestTipAddress = builder.digestTipAddress;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The location of the block that you want to request. An address is an Amazon Ion structure that has two fields:
     * <code>strandId</code> and <code>sequenceNo</code>.
     * </p>
     * <p>
     * For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>
     * </p>
     * 
     * @return The location of the block that you want to request. An address is an Amazon Ion structure that has two
     *         fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
     *         <p>
     *         For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>
     */
    public ValueHolder blockAddress() {
        return blockAddress;
    }

    /**
     * <p>
     * The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion
     * structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.
     * </p>
     * <p>
     * For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>
     * </p>
     * 
     * @return The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion
     *         structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
     *         <p>
     *         For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>
     */
    public ValueHolder digestTipAddress() {
        return digestTipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(blockAddress());
        hashCode = 31 * hashCode + Objects.hashCode(digestTipAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlockRequest)) {
            return false;
        }
        GetBlockRequest other = (GetBlockRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(blockAddress(), other.blockAddress())
                && Objects.equals(digestTipAddress(), other.digestTipAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBlockRequest").add("Name", name())
                .add("BlockAddress", blockAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DigestTipAddress", digestTipAddress() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "BlockAddress":
            return Optional.ofNullable(clazz.cast(blockAddress()));
        case "DigestTipAddress":
            return Optional.ofNullable(clazz.cast(digestTipAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlockRequest, T> g) {
        return obj -> g.apply((GetBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBlockRequest> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param name
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The location of the block that you want to request. An address is an Amazon Ion structure that has two
         * fields: <code>strandId</code> and <code>sequenceNo</code>.
         * </p>
         * <p>
         * For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>
         * </p>
         * 
         * @param blockAddress
         *        The location of the block that you want to request. An address is an Amazon Ion structure that has two
         *        fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
         *        <p>
         *        For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockAddress(ValueHolder blockAddress);

        /**
         * <p>
         * The location of the block that you want to request. An address is an Amazon Ion structure that has two
         * fields: <code>strandId</code> and <code>sequenceNo</code>.
         * </p>
         * <p>
         * For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}</code>
         * </p>
         * This is a convenience that creates an instance of the {@link ValueHolder.Builder} avoiding the need to create
         * one manually via {@link ValueHolder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValueHolder.Builder#build()} is called immediately and its result
         * is passed to {@link #blockAddress(ValueHolder)}.
         * 
         * @param blockAddress
         *        a consumer that will call methods on {@link ValueHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockAddress(ValueHolder)
         */
        default Builder blockAddress(Consumer<ValueHolder.Builder> blockAddress) {
            return blockAddress(ValueHolder.builder().applyMutation(blockAddress).build());
        }

        /**
         * <p>
         * The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion
         * structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.
         * </p>
         * <p>
         * For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>
         * </p>
         * 
         * @param digestTipAddress
         *        The latest block location covered by the digest for which to request a proof. An address is an Amazon
         *        Ion structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.</p>
         *        <p>
         *        For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digestTipAddress(ValueHolder digestTipAddress);

        /**
         * <p>
         * The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion
         * structure that has two fields: <code>strandId</code> and <code>sequenceNo</code>.
         * </p>
         * <p>
         * For example: <code>{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}</code>
         * </p>
         * This is a convenience that creates an instance of the {@link ValueHolder.Builder} avoiding the need to create
         * one manually via {@link ValueHolder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValueHolder.Builder#build()} is called immediately and its result
         * is passed to {@link #digestTipAddress(ValueHolder)}.
         * 
         * @param digestTipAddress
         *        a consumer that will call methods on {@link ValueHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #digestTipAddress(ValueHolder)
         */
        default Builder digestTipAddress(Consumer<ValueHolder.Builder> digestTipAddress) {
            return digestTipAddress(ValueHolder.builder().applyMutation(digestTipAddress).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QldbRequest.BuilderImpl implements Builder {
        private String name;

        private ValueHolder blockAddress;

        private ValueHolder digestTipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlockRequest model) {
            super(model);
            name(model.name);
            blockAddress(model.blockAddress);
            digestTipAddress(model.digestTipAddress);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ValueHolder.Builder getBlockAddress() {
            return blockAddress != null ? blockAddress.toBuilder() : null;
        }

        @Override
        public final Builder blockAddress(ValueHolder blockAddress) {
            this.blockAddress = blockAddress;
            return this;
        }

        public final void setBlockAddress(ValueHolder.BuilderImpl blockAddress) {
            this.blockAddress = blockAddress != null ? blockAddress.build() : null;
        }

        public final ValueHolder.Builder getDigestTipAddress() {
            return digestTipAddress != null ? digestTipAddress.toBuilder() : null;
        }

        @Override
        public final Builder digestTipAddress(ValueHolder digestTipAddress) {
            this.digestTipAddress = digestTipAddress;
            return this;
        }

        public final void setDigestTipAddress(ValueHolder.BuilderImpl digestTipAddress) {
            this.digestTipAddress = digestTipAddress != null ? digestTipAddress.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlockRequest build() {
            return new GetBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
