/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlockResponse extends QldbResponse implements ToCopyableBuilder<GetBlockResponse.Builder, GetBlockResponse> {
    private static final SdkField<ValueHolder> BLOCK_FIELD = SdkField.<ValueHolder> builder(MarshallingType.SDK_POJO)
            .memberName("Block").getter(getter(GetBlockResponse::block)).setter(setter(Builder::block))
            .constructor(ValueHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()).build();

    private static final SdkField<ValueHolder> PROOF_FIELD = SdkField.<ValueHolder> builder(MarshallingType.SDK_POJO)
            .memberName("Proof").getter(getter(GetBlockResponse::proof)).setter(setter(Builder::proof))
            .constructor(ValueHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proof").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_FIELD, PROOF_FIELD));

    private final ValueHolder block;

    private final ValueHolder proof;

    private GetBlockResponse(BuilderImpl builder) {
        super(builder);
        this.block = builder.block;
        this.proof = builder.proof;
    }

    /**
     * <p>
     * The block data object in Amazon Ion format.
     * </p>
     * 
     * @return The block data object in Amazon Ion format.
     */
    public ValueHolder block() {
        return block;
    }

    /**
     * <p>
     * The proof object in Amazon Ion format returned by a <code>GetBlock</code> request. A proof contains the list of
     * hash values required to recalculate the specified digest using a Merkle tree, starting with the specified block.
     * </p>
     * 
     * @return The proof object in Amazon Ion format returned by a <code>GetBlock</code> request. A proof contains the
     *         list of hash values required to recalculate the specified digest using a Merkle tree, starting with the
     *         specified block.
     */
    public ValueHolder proof() {
        return proof;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(block());
        hashCode = 31 * hashCode + Objects.hashCode(proof());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlockResponse)) {
            return false;
        }
        GetBlockResponse other = (GetBlockResponse) obj;
        return Objects.equals(block(), other.block()) && Objects.equals(proof(), other.proof());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBlockResponse").add("Block", block() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Proof", proof() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "Proof":
            return Optional.ofNullable(clazz.cast(proof()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlockResponse, T> g) {
        return obj -> g.apply((GetBlockResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBlockResponse> {
        /**
         * <p>
         * The block data object in Amazon Ion format.
         * </p>
         * 
         * @param block
         *        The block data object in Amazon Ion format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(ValueHolder block);

        /**
         * <p>
         * The block data object in Amazon Ion format.
         * </p>
         * This is a convenience that creates an instance of the {@link ValueHolder.Builder} avoiding the need to create
         * one manually via {@link ValueHolder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValueHolder.Builder#build()} is called immediately and its result
         * is passed to {@link #block(ValueHolder)}.
         * 
         * @param block
         *        a consumer that will call methods on {@link ValueHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(ValueHolder)
         */
        default Builder block(Consumer<ValueHolder.Builder> block) {
            return block(ValueHolder.builder().applyMutation(block).build());
        }

        /**
         * <p>
         * The proof object in Amazon Ion format returned by a <code>GetBlock</code> request. A proof contains the list
         * of hash values required to recalculate the specified digest using a Merkle tree, starting with the specified
         * block.
         * </p>
         * 
         * @param proof
         *        The proof object in Amazon Ion format returned by a <code>GetBlock</code> request. A proof contains
         *        the list of hash values required to recalculate the specified digest using a Merkle tree, starting
         *        with the specified block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proof(ValueHolder proof);

        /**
         * <p>
         * The proof object in Amazon Ion format returned by a <code>GetBlock</code> request. A proof contains the list
         * of hash values required to recalculate the specified digest using a Merkle tree, starting with the specified
         * block.
         * </p>
         * This is a convenience that creates an instance of the {@link ValueHolder.Builder} avoiding the need to create
         * one manually via {@link ValueHolder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValueHolder.Builder#build()} is called immediately and its result
         * is passed to {@link #proof(ValueHolder)}.
         * 
         * @param proof
         *        a consumer that will call methods on {@link ValueHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proof(ValueHolder)
         */
        default Builder proof(Consumer<ValueHolder.Builder> proof) {
            return proof(ValueHolder.builder().applyMutation(proof).build());
        }
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private ValueHolder block;

        private ValueHolder proof;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlockResponse model) {
            super(model);
            block(model.block);
            proof(model.proof);
        }

        public final ValueHolder.Builder getBlock() {
            return block != null ? block.toBuilder() : null;
        }

        @Override
        public final Builder block(ValueHolder block) {
            this.block = block;
            return this;
        }

        public final void setBlock(ValueHolder.BuilderImpl block) {
            this.block = block != null ? block.build() : null;
        }

        public final ValueHolder.Builder getProof() {
            return proof != null ? proof.toBuilder() : null;
        }

        @Override
        public final Builder proof(ValueHolder proof) {
            this.proof = proof;
            return this;
        }

        public final void setProof(ValueHolder.BuilderImpl proof) {
            this.proof = proof != null ? proof.build() : null;
        }

        @Override
        public GetBlockResponse build() {
            return new GetBlockResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
