/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLedgersResponse extends QldbResponse implements
        ToCopyableBuilder<ListLedgersResponse.Builder, ListLedgersResponse> {
    private static final SdkField<List<LedgerSummary>> LEDGERS_FIELD = SdkField
            .<List<LedgerSummary>> builder(MarshallingType.LIST)
            .memberName("Ledgers")
            .getter(getter(ListLedgersResponse::ledgers))
            .setter(setter(Builder::ledgers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ledgers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LedgerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LedgerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLedgersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LedgerSummary> ledgers;

    private final String nextToken;

    private ListLedgersResponse(BuilderImpl builder) {
        super(builder);
        this.ledgers = builder.ledgers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Ledgers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasLedgers() {
        return ledgers != null && !(ledgers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of ledger summaries that are associated with the current AWS account and Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLedgers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of ledger summaries that are associated with the current AWS account and Region.
     */
    public List<LedgerSummary> ledgers() {
        return ledgers;
    }

    /**
     * <p>
     * A pagination token, indicating whether there are more results available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>NextToken</code> is empty, then the last page of results has been processed and there are no more
     * results to be retrieved.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the next page
     * of results, use the value of <code>NextToken</code> in a subsequent <code>ListLedgers</code> call.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A pagination token, indicating whether there are more results available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>NextToken</code> is empty, then the last page of results has been processed and there are no
     *         more results to be retrieved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the
     *         next page of results, use the value of <code>NextToken</code> in a subsequent <code>ListLedgers</code>
     *         call.
     *         </p>
     *         </li>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLedgers() ? ledgers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLedgersResponse)) {
            return false;
        }
        ListLedgersResponse other = (ListLedgersResponse) obj;
        return hasLedgers() == other.hasLedgers() && Objects.equals(ledgers(), other.ledgers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListLedgersResponse").add("Ledgers", hasLedgers() ? ledgers() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ledgers":
            return Optional.ofNullable(clazz.cast(ledgers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLedgersResponse, T> g) {
        return obj -> g.apply((ListLedgersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLedgersResponse> {
        /**
         * <p>
         * The array of ledger summaries that are associated with the current AWS account and Region.
         * </p>
         * 
         * @param ledgers
         *        The array of ledger summaries that are associated with the current AWS account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ledgers(Collection<LedgerSummary> ledgers);

        /**
         * <p>
         * The array of ledger summaries that are associated with the current AWS account and Region.
         * </p>
         * 
         * @param ledgers
         *        The array of ledger summaries that are associated with the current AWS account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ledgers(LedgerSummary... ledgers);

        /**
         * <p>
         * The array of ledger summaries that are associated with the current AWS account and Region.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LedgerSummary>.Builder} avoiding the need
         * to create one manually via {@link List<LedgerSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LedgerSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #ledgers(List<LedgerSummary>)}.
         * 
         * @param ledgers
         *        a consumer that will call methods on {@link List<LedgerSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ledgers(List<LedgerSummary>)
         */
        Builder ledgers(Consumer<LedgerSummary.Builder>... ledgers);

        /**
         * <p>
         * A pagination token, indicating whether there are more results available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>NextToken</code> is empty, then the last page of results has been processed and there are no more
         * results to be retrieved.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the next
         * page of results, use the value of <code>NextToken</code> in a subsequent <code>ListLedgers</code> call.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nextToken
         *        A pagination token, indicating whether there are more results available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>NextToken</code> is empty, then the last page of results has been processed and there are no
         *        more results to be retrieved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>NextToken</code> is <i>not</i> empty, then there are more results available. To retrieve the
         *        next page of results, use the value of <code>NextToken</code> in a subsequent <code>ListLedgers</code>
         *        call.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private List<LedgerSummary> ledgers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLedgersResponse model) {
            super(model);
            ledgers(model.ledgers);
            nextToken(model.nextToken);
        }

        public final Collection<LedgerSummary.Builder> getLedgers() {
            if (ledgers instanceof SdkAutoConstructList) {
                return null;
            }
            return ledgers != null ? ledgers.stream().map(LedgerSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ledgers(Collection<LedgerSummary> ledgers) {
            this.ledgers = LedgerListCopier.copy(ledgers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ledgers(LedgerSummary... ledgers) {
            ledgers(Arrays.asList(ledgers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ledgers(Consumer<LedgerSummary.Builder>... ledgers) {
            ledgers(Stream.of(ledgers).map(c -> LedgerSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLedgers(Collection<LedgerSummary.BuilderImpl> ledgers) {
            this.ledgers = LedgerListCopier.copyFromBuilder(ledgers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLedgersResponse build() {
            return new ListLedgersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
