/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.QldbRequest;
import software.amazon.awssdk.services.qldb.model.ValueHolder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlockRequest
extends QldbRequest
implements ToCopyableBuilder<Builder, GetBlockRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetBlockRequest.getter(GetBlockRequest::name)).setter(GetBlockRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<ValueHolder> BLOCK_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlockAddress").getter(GetBlockRequest.getter(GetBlockRequest::blockAddress)).setter(GetBlockRequest.setter(Builder::blockAddress)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockAddress").build()}).build();
    private static final SdkField<ValueHolder> DIGEST_TIP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DigestTipAddress").getter(GetBlockRequest.getter(GetBlockRequest::digestTipAddress)).setter(GetBlockRequest.setter(Builder::digestTipAddress)).constructor(ValueHolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestTipAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BLOCK_ADDRESS_FIELD, DIGEST_TIP_ADDRESS_FIELD));
    private final String name;
    private final ValueHolder blockAddress;
    private final ValueHolder digestTipAddress;

    private GetBlockRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.blockAddress = builder.blockAddress;
        this.digestTipAddress = builder.digestTipAddress;
    }

    public String name() {
        return this.name;
    }

    public ValueHolder blockAddress() {
        return this.blockAddress;
    }

    public ValueHolder digestTipAddress() {
        return this.digestTipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.digestTipAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlockRequest)) {
            return false;
        }
        GetBlockRequest other = (GetBlockRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.blockAddress(), other.blockAddress()) && Objects.equals(this.digestTipAddress(), other.digestTipAddress());
    }

    public String toString() {
        return ToString.builder((String)"GetBlockRequest").add("Name", (Object)this.name()).add("BlockAddress", (Object)(this.blockAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("DigestTipAddress", (Object)(this.digestTipAddress() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "BlockAddress": {
                return Optional.ofNullable(clazz.cast(this.blockAddress()));
            }
            case "DigestTipAddress": {
                return Optional.ofNullable(clazz.cast(this.digestTipAddress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlockRequest, T> g) {
        return obj -> g.apply((GetBlockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbRequest.BuilderImpl
    implements Builder {
        private String name;
        private ValueHolder blockAddress;
        private ValueHolder digestTipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlockRequest model) {
            super(model);
            this.name(model.name);
            this.blockAddress(model.blockAddress);
            this.digestTipAddress(model.digestTipAddress);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ValueHolder.Builder getBlockAddress() {
            return this.blockAddress != null ? this.blockAddress.toBuilder() : null;
        }

        @Override
        public final Builder blockAddress(ValueHolder blockAddress) {
            this.blockAddress = blockAddress;
            return this;
        }

        public final void setBlockAddress(ValueHolder.BuilderImpl blockAddress) {
            this.blockAddress = blockAddress != null ? blockAddress.build() : null;
        }

        public final ValueHolder.Builder getDigestTipAddress() {
            return this.digestTipAddress != null ? this.digestTipAddress.toBuilder() : null;
        }

        @Override
        public final Builder digestTipAddress(ValueHolder digestTipAddress) {
            this.digestTipAddress = digestTipAddress;
            return this;
        }

        public final void setDigestTipAddress(ValueHolder.BuilderImpl digestTipAddress) {
            this.digestTipAddress = digestTipAddress != null ? digestTipAddress.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBlockRequest build() {
            return new GetBlockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlockRequest> {
        public Builder name(String var1);

        public Builder blockAddress(ValueHolder var1);

        default public Builder blockAddress(Consumer<ValueHolder.Builder> blockAddress) {
            return this.blockAddress((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(blockAddress)).build());
        }

        public Builder digestTipAddress(ValueHolder var1);

        default public Builder digestTipAddress(Consumer<ValueHolder.Builder> digestTipAddress) {
            return this.digestTipAddress((ValueHolder)((ValueHolder.Builder)ValueHolder.builder().applyMutation(digestTipAddress)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

