/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class JournalS3ExportListCopier {
    static List<JournalS3ExportDescription> copy(Collection<? extends JournalS3ExportDescription> journalS3ExportListParam) {
        List<JournalS3ExportDescription> list;
        if (journalS3ExportListParam == null || journalS3ExportListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<JournalS3ExportDescription> modifiableList = new ArrayList<>();
            journalS3ExportListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<JournalS3ExportDescription> copyFromBuilder(
            Collection<? extends JournalS3ExportDescription.Builder> journalS3ExportListParam) {
        List<JournalS3ExportDescription> list;
        if (journalS3ExportListParam == null || journalS3ExportListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<JournalS3ExportDescription> modifiableList = new ArrayList<>();
            journalS3ExportListParam.forEach(entry -> {
                JournalS3ExportDescription member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<JournalS3ExportDescription.Builder> copyToBuilder(
            Collection<? extends JournalS3ExportDescription> journalS3ExportListParam) {
        List<JournalS3ExportDescription.Builder> list;
        if (journalS3ExportListParam == null || journalS3ExportListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<JournalS3ExportDescription.Builder> modifiableList = new ArrayList<>();
            journalS3ExportListParam.forEach(entry -> {
                JournalS3ExportDescription.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
