/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.LedgerEncryptionDescription;
import software.amazon.awssdk.services.qldb.model.LedgerState;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLedgerResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, UpdateLedgerResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateLedgerResponse.getter(UpdateLedgerResponse::name)).setter(UpdateLedgerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateLedgerResponse.getter(UpdateLedgerResponse::arn)).setter(UpdateLedgerResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateLedgerResponse.getter(UpdateLedgerResponse::stateAsString)).setter(UpdateLedgerResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDateTime").getter(UpdateLedgerResponse.getter(UpdateLedgerResponse::creationDateTime)).setter(UpdateLedgerResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(UpdateLedgerResponse.getter(UpdateLedgerResponse::deletionProtection)).setter(UpdateLedgerResponse.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<LedgerEncryptionDescription> ENCRYPTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionDescription").getter(UpdateLedgerResponse.getter(UpdateLedgerResponse::encryptionDescription)).setter(UpdateLedgerResponse.setter(Builder::encryptionDescription)).constructor(LedgerEncryptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, STATE_FIELD, CREATION_DATE_TIME_FIELD, DELETION_PROTECTION_FIELD, ENCRYPTION_DESCRIPTION_FIELD));
    private final String name;
    private final String arn;
    private final String state;
    private final Instant creationDateTime;
    private final Boolean deletionProtection;
    private final LedgerEncryptionDescription encryptionDescription;

    private UpdateLedgerResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
        this.deletionProtection = builder.deletionProtection;
        this.encryptionDescription = builder.encryptionDescription;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final LedgerState state() {
        return LedgerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final LedgerEncryptionDescription encryptionDescription() {
        return this.encryptionDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLedgerResponse)) {
            return false;
        }
        UpdateLedgerResponse other = (UpdateLedgerResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.encryptionDescription(), other.encryptionDescription());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLedgerResponse").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("State", (Object)this.stateAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("DeletionProtection", (Object)this.deletionProtection()).add("EncryptionDescription", (Object)this.encryptionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "EncryptionDescription": {
                return Optional.ofNullable(clazz.cast(this.encryptionDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLedgerResponse, T> g) {
        return obj -> g.apply((UpdateLedgerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String state;
        private Instant creationDateTime;
        private Boolean deletionProtection;
        private LedgerEncryptionDescription encryptionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLedgerResponse model) {
            super(model);
            this.name(model.name);
            this.arn(model.arn);
            this.state(model.state);
            this.creationDateTime(model.creationDateTime);
            this.deletionProtection(model.deletionProtection);
            this.encryptionDescription(model.encryptionDescription);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(LedgerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        @Transient
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final LedgerEncryptionDescription.Builder getEncryptionDescription() {
            return this.encryptionDescription != null ? this.encryptionDescription.toBuilder() : null;
        }

        public final void setEncryptionDescription(LedgerEncryptionDescription.BuilderImpl encryptionDescription) {
            this.encryptionDescription = encryptionDescription != null ? encryptionDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionDescription(LedgerEncryptionDescription encryptionDescription) {
            this.encryptionDescription = encryptionDescription;
            return this;
        }

        @Override
        public UpdateLedgerResponse build() {
            return new UpdateLedgerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLedgerResponse> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder state(String var1);

        public Builder state(LedgerState var1);

        public Builder creationDateTime(Instant var1);

        public Builder deletionProtection(Boolean var1);

        public Builder encryptionDescription(LedgerEncryptionDescription var1);

        default public Builder encryptionDescription(Consumer<LedgerEncryptionDescription.Builder> encryptionDescription) {
            return this.encryptionDescription((LedgerEncryptionDescription)((LedgerEncryptionDescription.Builder)LedgerEncryptionDescription.builder().applyMutation(encryptionDescription)).build());
        }
    }
}

