/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qldb.model.JournalS3ExportDescription;
import software.amazon.awssdk.services.qldb.model.JournalS3ExportListCopier;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJournalS3ExportsForLedgerResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, ListJournalS3ExportsForLedgerResponse> {
    private static final SdkField<List<JournalS3ExportDescription>> JOURNAL_S3_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JournalS3Exports").getter(ListJournalS3ExportsForLedgerResponse.getter(ListJournalS3ExportsForLedgerResponse::journalS3Exports)).setter(ListJournalS3ExportsForLedgerResponse.setter(Builder::journalS3Exports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JournalS3Exports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JournalS3ExportDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListJournalS3ExportsForLedgerResponse.getter(ListJournalS3ExportsForLedgerResponse::nextToken)).setter(ListJournalS3ExportsForLedgerResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOURNAL_S3_EXPORTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<JournalS3ExportDescription> journalS3Exports;
    private final String nextToken;

    private ListJournalS3ExportsForLedgerResponse(BuilderImpl builder) {
        super(builder);
        this.journalS3Exports = builder.journalS3Exports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJournalS3Exports() {
        return this.journalS3Exports != null && !(this.journalS3Exports instanceof SdkAutoConstructList);
    }

    public final List<JournalS3ExportDescription> journalS3Exports() {
        return this.journalS3Exports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJournalS3Exports() ? this.journalS3Exports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJournalS3ExportsForLedgerResponse)) {
            return false;
        }
        ListJournalS3ExportsForLedgerResponse other = (ListJournalS3ExportsForLedgerResponse)((Object)obj);
        return this.hasJournalS3Exports() == other.hasJournalS3Exports() && Objects.equals(this.journalS3Exports(), other.journalS3Exports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJournalS3ExportsForLedgerResponse").add("JournalS3Exports", this.hasJournalS3Exports() ? this.journalS3Exports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JournalS3Exports": {
                return Optional.ofNullable(clazz.cast(this.journalS3Exports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJournalS3ExportsForLedgerResponse, T> g) {
        return obj -> g.apply((ListJournalS3ExportsForLedgerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private List<JournalS3ExportDescription> journalS3Exports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJournalS3ExportsForLedgerResponse model) {
            super(model);
            this.journalS3Exports(model.journalS3Exports);
            this.nextToken(model.nextToken);
        }

        public final List<JournalS3ExportDescription.Builder> getJournalS3Exports() {
            List<JournalS3ExportDescription.Builder> result = JournalS3ExportListCopier.copyToBuilder(this.journalS3Exports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJournalS3Exports(Collection<JournalS3ExportDescription.BuilderImpl> journalS3Exports) {
            this.journalS3Exports = JournalS3ExportListCopier.copyFromBuilder(journalS3Exports);
        }

        @Override
        @Transient
        public final Builder journalS3Exports(Collection<JournalS3ExportDescription> journalS3Exports) {
            this.journalS3Exports = JournalS3ExportListCopier.copy(journalS3Exports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder journalS3Exports(JournalS3ExportDescription ... journalS3Exports) {
            this.journalS3Exports(Arrays.asList(journalS3Exports));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder journalS3Exports(Consumer<JournalS3ExportDescription.Builder> ... journalS3Exports) {
            this.journalS3Exports(Stream.of(journalS3Exports).map(c -> (JournalS3ExportDescription)((JournalS3ExportDescription.Builder)JournalS3ExportDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJournalS3ExportsForLedgerResponse build() {
            return new ListJournalS3ExportsForLedgerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJournalS3ExportsForLedgerResponse> {
        public Builder journalS3Exports(Collection<JournalS3ExportDescription> var1);

        public Builder journalS3Exports(JournalS3ExportDescription ... var1);

        public Builder journalS3Exports(Consumer<JournalS3ExportDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

