/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLedgerResponse extends QldbResponse implements
        ToCopyableBuilder<DescribeLedgerResponse.Builder, DescribeLedgerResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeLedgerResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeLedgerResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeLedgerResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDateTime").getter(getter(DescribeLedgerResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final SdkField<String> PERMISSIONS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionsMode").getter(getter(DescribeLedgerResponse::permissionsModeAsString))
            .setter(setter(Builder::permissionsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsMode").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(DescribeLedgerResponse::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<LedgerEncryptionDescription> ENCRYPTION_DESCRIPTION_FIELD = SdkField
            .<LedgerEncryptionDescription> builder(MarshallingType.SDK_POJO).memberName("EncryptionDescription")
            .getter(getter(DescribeLedgerResponse::encryptionDescription)).setter(setter(Builder::encryptionDescription))
            .constructor(LedgerEncryptionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            STATE_FIELD, CREATION_DATE_TIME_FIELD, PERMISSIONS_MODE_FIELD, DELETION_PROTECTION_FIELD,
            ENCRYPTION_DESCRIPTION_FIELD));

    private final String name;

    private final String arn;

    private final String state;

    private final Instant creationDateTime;

    private final String permissionsMode;

    private final Boolean deletionProtection;

    private final LedgerEncryptionDescription encryptionDescription;

    private DescribeLedgerResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
        this.permissionsMode = builder.permissionsMode;
        this.deletionProtection = builder.deletionProtection;
        this.encryptionDescription = builder.encryptionDescription;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the ledger.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the ledger.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LedgerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current status of the ledger.
     * @see LedgerState
     */
    public final LedgerState state() {
        return LedgerState.fromValue(state);
    }

    /**
     * <p>
     * The current status of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link LedgerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current status of the ledger.
     * @see LedgerState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of seconds
     * elapsed since 12:00:00 AM January 1, 1970 UTC.)
     * </p>
     * 
     * @return The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of
     *         seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The permissions mode of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The permissions mode of the ledger.
     * @see PermissionsMode
     */
    public final PermissionsMode permissionsMode() {
        return PermissionsMode.fromValue(permissionsMode);
    }

    /**
     * <p>
     * The permissions mode of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The permissions mode of the ledger.
     * @see PermissionsMode
     */
    public final String permissionsModeAsString() {
        return permissionsMode;
    }

    /**
     * <p>
     * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature
     * is enabled (<code>true</code>) by default.
     * </p>
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it
     * by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.
     * </p>
     * 
     * @return The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this
     *         feature is enabled (<code>true</code>) by default.</p>
     *         <p>
     *         If deletion protection is enabled, you must first disable it before you can delete the ledger. You can
     *         disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Information about the encryption of data at rest in the ledger. This includes the current status, the KMS key,
     * and when the key became inaccessible (in the case of an error).
     * </p>
     * 
     * @return Information about the encryption of data at rest in the ledger. This includes the current status, the KMS
     *         key, and when the key became inaccessible (in the case of an error).
     */
    public final LedgerEncryptionDescription encryptionDescription() {
        return encryptionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLedgerResponse)) {
            return false;
        }
        DescribeLedgerResponse other = (DescribeLedgerResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(permissionsModeAsString(), other.permissionsModeAsString())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(encryptionDescription(), other.encryptionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLedgerResponse").add("Name", name()).add("Arn", arn()).add("State", stateAsString())
                .add("CreationDateTime", creationDateTime()).add("PermissionsMode", permissionsModeAsString())
                .add("DeletionProtection", deletionProtection()).add("EncryptionDescription", encryptionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "PermissionsMode":
            return Optional.ofNullable(clazz.cast(permissionsModeAsString()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "EncryptionDescription":
            return Optional.ofNullable(clazz.cast(encryptionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLedgerResponse, T> g) {
        return obj -> g.apply((DescribeLedgerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLedgerResponse> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param name
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the ledger.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the ledger.
         * </p>
         * 
         * @param state
         *        The current status of the ledger.
         * @see LedgerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LedgerState
         */
        Builder state(String state);

        /**
         * <p>
         * The current status of the ledger.
         * </p>
         * 
         * @param state
         *        The current status of the ledger.
         * @see LedgerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LedgerState
         */
        Builder state(LedgerState state);

        /**
         * <p>
         * The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number of
         * seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * </p>
         * 
         * @param creationDateTime
         *        The date and time, in epoch time format, when the ledger was created. (Epoch time format is the number
         *        of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The permissions mode of the ledger.
         * </p>
         * 
         * @param permissionsMode
         *        The permissions mode of the ledger.
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(String permissionsMode);

        /**
         * <p>
         * The permissions mode of the ledger.
         * </p>
         * 
         * @param permissionsMode
         *        The permissions mode of the ledger.
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(PermissionsMode permissionsMode);

        /**
         * <p>
         * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this
         * feature is enabled (<code>true</code>) by default.
         * </p>
         * <p>
         * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can
         * disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.
         * </p>
         * 
         * @param deletionProtection
         *        The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation,
         *        this feature is enabled (<code>true</code>) by default.</p>
         *        <p>
         *        If deletion protection is enabled, you must first disable it before you can delete the ledger. You can
         *        disable it by calling the <code>UpdateLedger</code> operation to set the flag to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Information about the encryption of data at rest in the ledger. This includes the current status, the KMS
         * key, and when the key became inaccessible (in the case of an error).
         * </p>
         * 
         * @param encryptionDescription
         *        Information about the encryption of data at rest in the ledger. This includes the current status, the
         *        KMS key, and when the key became inaccessible (in the case of an error).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDescription(LedgerEncryptionDescription encryptionDescription);

        /**
         * <p>
         * Information about the encryption of data at rest in the ledger. This includes the current status, the KMS
         * key, and when the key became inaccessible (in the case of an error).
         * </p>
         * This is a convenience that creates an instance of the {@link LedgerEncryptionDescription.Builder} avoiding
         * the need to create one manually via {@link LedgerEncryptionDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link LedgerEncryptionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionDescription(LedgerEncryptionDescription)}.
         * 
         * @param encryptionDescription
         *        a consumer that will call methods on {@link LedgerEncryptionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionDescription(LedgerEncryptionDescription)
         */
        default Builder encryptionDescription(Consumer<LedgerEncryptionDescription.Builder> encryptionDescription) {
            return encryptionDescription(LedgerEncryptionDescription.builder().applyMutation(encryptionDescription).build());
        }
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String state;

        private Instant creationDateTime;

        private String permissionsMode;

        private Boolean deletionProtection;

        private LedgerEncryptionDescription encryptionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLedgerResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            state(model.state);
            creationDateTime(model.creationDateTime);
            permissionsMode(model.permissionsMode);
            deletionProtection(model.deletionProtection);
            encryptionDescription(model.encryptionDescription);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(LedgerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getPermissionsMode() {
            return permissionsMode;
        }

        public final void setPermissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
        }

        @Override
        @Transient
        public final Builder permissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
            return this;
        }

        @Override
        @Transient
        public final Builder permissionsMode(PermissionsMode permissionsMode) {
            this.permissionsMode(permissionsMode == null ? null : permissionsMode.toString());
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        @Transient
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final LedgerEncryptionDescription.Builder getEncryptionDescription() {
            return encryptionDescription != null ? encryptionDescription.toBuilder() : null;
        }

        public final void setEncryptionDescription(LedgerEncryptionDescription.BuilderImpl encryptionDescription) {
            this.encryptionDescription = encryptionDescription != null ? encryptionDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionDescription(LedgerEncryptionDescription encryptionDescription) {
            this.encryptionDescription = encryptionDescription;
            return this;
        }

        @Override
        public DescribeLedgerResponse build() {
            return new DescribeLedgerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
