/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLedgerPermissionsModeRequest extends QldbRequest implements
        ToCopyableBuilder<UpdateLedgerPermissionsModeRequest.Builder, UpdateLedgerPermissionsModeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateLedgerPermissionsModeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> PERMISSIONS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionsMode").getter(getter(UpdateLedgerPermissionsModeRequest::permissionsModeAsString))
            .setter(setter(Builder::permissionsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PERMISSIONS_MODE_FIELD));

    private final String name;

    private final String permissionsMode;

    private UpdateLedgerPermissionsModeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.permissionsMode = builder.permissionsMode;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The permissions mode to assign to the ledger. This parameter can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for
     * ledgers.
     * </p>
     * <p>
     * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL
     * commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any
     * table-level or command-level IAM permissions policies that you create for the ledger.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity
     * for ledgers, tables, and PartiQL commands.
     * </p>
     * <p>
     * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow
     * PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL
     * actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started
     * with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger
     * data.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The permissions mode to assign to the ledger. This parameter can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity
     *         for ledgers.
     *         </p>
     *         <p>
     *         This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all
     *         PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode
     *         disregards any table-level or command-level IAM permissions policies that you create for the ledger.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer
     *         granularity for ledgers, tables, and PartiQL commands.
     *         </p>
     *         <p>
     *         By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger.
     *         To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources
     *         and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For
     *         information, see <a
     *         href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
     *         started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your
     *         ledger data.
     *         </p>
     * @see PermissionsMode
     */
    public final PermissionsMode permissionsMode() {
        return PermissionsMode.fromValue(permissionsMode);
    }

    /**
     * <p>
     * The permissions mode to assign to the ledger. This parameter can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for
     * ledgers.
     * </p>
     * <p>
     * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all PartiQL
     * commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards any
     * table-level or command-level IAM permissions policies that you create for the ledger.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer granularity
     * for ledgers, tables, and PartiQL commands.
     * </p>
     * <p>
     * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To allow
     * PartiQL commands to run, you must create IAM permissions policies for specific table resources and PartiQL
     * actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information, see <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting started
     * with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your ledger
     * data.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The permissions mode to assign to the ledger. This parameter can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity
     *         for ledgers.
     *         </p>
     *         <p>
     *         This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all
     *         PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode
     *         disregards any table-level or command-level IAM permissions policies that you create for the ledger.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer
     *         granularity for ledgers, tables, and PartiQL commands.
     *         </p>
     *         <p>
     *         By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger.
     *         To allow PartiQL commands to run, you must create IAM permissions policies for specific table resources
     *         and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For
     *         information, see <a
     *         href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
     *         started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your
     *         ledger data.
     *         </p>
     * @see PermissionsMode
     */
    public final String permissionsModeAsString() {
        return permissionsMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLedgerPermissionsModeRequest)) {
            return false;
        }
        UpdateLedgerPermissionsModeRequest other = (UpdateLedgerPermissionsModeRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(permissionsModeAsString(), other.permissionsModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLedgerPermissionsModeRequest").add("Name", name())
                .add("PermissionsMode", permissionsModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PermissionsMode":
            return Optional.ofNullable(clazz.cast(permissionsModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLedgerPermissionsModeRequest, T> g) {
        return obj -> g.apply((UpdateLedgerPermissionsModeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLedgerPermissionsModeRequest> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param name
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The permissions mode to assign to the ledger. This parameter can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for
         * ledgers.
         * </p>
         * <p>
         * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all
         * PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards
         * any table-level or command-level IAM permissions policies that you create for the ledger.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer
         * granularity for ledgers, tables, and PartiQL commands.
         * </p>
         * <p>
         * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To
         * allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and
         * PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information,
         * see <a
         * href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
         * started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your
         * ledger data.
         * </p>
         * </note>
         * 
         * @param permissionsMode
         *        The permissions mode to assign to the ledger. This parameter can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level
         *        granularity for ledgers.
         *        </p>
         *        <p>
         *        This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all
         *        PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode
         *        disregards any table-level or command-level IAM permissions policies that you create for the ledger.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer
         *        granularity for ledgers, tables, and PartiQL commands.
         *        </p>
         *        <p>
         *        By default, this mode denies all user requests to run any PartiQL commands on any tables in this
         *        ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table
         *        resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the
         *        ledger. For information, see <a
         *        href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html"
         *        >Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of
         *        your ledger data.
         *        </p>
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(String permissionsMode);

        /**
         * <p>
         * The permissions mode to assign to the ledger. This parameter can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level granularity for
         * ledgers.
         * </p>
         * <p>
         * This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all
         * PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode disregards
         * any table-level or command-level IAM permissions policies that you create for the ledger.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer
         * granularity for ledgers, tables, and PartiQL commands.
         * </p>
         * <p>
         * By default, this mode denies all user requests to run any PartiQL commands on any tables in this ledger. To
         * allow PartiQL commands to run, you must create IAM permissions policies for specific table resources and
         * PartiQL actions, in addition to the <code>SendCommand</code> API permission for the ledger. For information,
         * see <a
         * href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
         * started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of your
         * ledger data.
         * </p>
         * </note>
         * 
         * @param permissionsMode
         *        The permissions mode to assign to the ledger. This parameter can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW_ALL</code>: A legacy permissions mode that enables access control with API-level
         *        granularity for ledgers.
         *        </p>
         *        <p>
         *        This mode allows users who have the <code>SendCommand</code> API permission for this ledger to run all
         *        PartiQL commands (hence, <code>ALLOW_ALL</code>) on any tables in the specified ledger. This mode
         *        disregards any table-level or command-level IAM permissions policies that you create for the ledger.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code>: (<i>Recommended</i>) A permissions mode that enables access control with finer
         *        granularity for ledgers, tables, and PartiQL commands.
         *        </p>
         *        <p>
         *        By default, this mode denies all user requests to run any PartiQL commands on any tables in this
         *        ledger. To allow PartiQL commands to run, you must create IAM permissions policies for specific table
         *        resources and PartiQL actions, in addition to the <code>SendCommand</code> API permission for the
         *        ledger. For information, see <a
         *        href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html"
         *        >Getting started with the standard permissions mode</a> in the <i>Amazon QLDB Developer Guide</i>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        We strongly recommend using the <code>STANDARD</code> permissions mode to maximize the security of
         *        your ledger data.
         *        </p>
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(PermissionsMode permissionsMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QldbRequest.BuilderImpl implements Builder {
        private String name;

        private String permissionsMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLedgerPermissionsModeRequest model) {
            super(model);
            name(model.name);
            permissionsMode(model.permissionsMode);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPermissionsMode() {
            return permissionsMode;
        }

        public final void setPermissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
        }

        @Override
        @Transient
        public final Builder permissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
            return this;
        }

        @Override
        @Transient
        public final Builder permissionsMode(PermissionsMode permissionsMode) {
            this.permissionsMode(permissionsMode == null ? null : permissionsMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLedgerPermissionsModeRequest build() {
            return new UpdateLedgerPermissionsModeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
