/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLedgerPermissionsModeResponse extends QldbResponse implements
        ToCopyableBuilder<UpdateLedgerPermissionsModeResponse.Builder, UpdateLedgerPermissionsModeResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateLedgerPermissionsModeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateLedgerPermissionsModeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PERMISSIONS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionsMode").getter(getter(UpdateLedgerPermissionsModeResponse::permissionsModeAsString))
            .setter(setter(Builder::permissionsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            PERMISSIONS_MODE_FIELD));

    private final String name;

    private final String arn;

    private final String permissionsMode;

    private UpdateLedgerPermissionsModeResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.permissionsMode = builder.permissionsMode;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the ledger.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the ledger.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current permissions mode of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The current permissions mode of the ledger.
     * @see PermissionsMode
     */
    public final PermissionsMode permissionsMode() {
        return PermissionsMode.fromValue(permissionsMode);
    }

    /**
     * <p>
     * The current permissions mode of the ledger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The current permissions mode of the ledger.
     * @see PermissionsMode
     */
    public final String permissionsModeAsString() {
        return permissionsMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLedgerPermissionsModeResponse)) {
            return false;
        }
        UpdateLedgerPermissionsModeResponse other = (UpdateLedgerPermissionsModeResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(permissionsModeAsString(), other.permissionsModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLedgerPermissionsModeResponse").add("Name", name()).add("Arn", arn())
                .add("PermissionsMode", permissionsModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PermissionsMode":
            return Optional.ofNullable(clazz.cast(permissionsModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLedgerPermissionsModeResponse, T> g) {
        return obj -> g.apply((UpdateLedgerPermissionsModeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLedgerPermissionsModeResponse> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param name
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the ledger.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current permissions mode of the ledger.
         * </p>
         * 
         * @param permissionsMode
         *        The current permissions mode of the ledger.
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(String permissionsMode);

        /**
         * <p>
         * The current permissions mode of the ledger.
         * </p>
         * 
         * @param permissionsMode
         *        The current permissions mode of the ledger.
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(PermissionsMode permissionsMode);
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String permissionsMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLedgerPermissionsModeResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            permissionsMode(model.permissionsMode);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPermissionsMode() {
            return permissionsMode;
        }

        public final void setPermissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
        }

        @Override
        @Transient
        public final Builder permissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
            return this;
        }

        @Override
        @Transient
        public final Builder permissionsMode(PermissionsMode permissionsMode) {
            this.permissionsMode(permissionsMode == null ? null : permissionsMode.toString());
            return this;
        }

        @Override
        public UpdateLedgerPermissionsModeResponse build() {
            return new UpdateLedgerPermissionsModeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
