/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qldb.model.KinesisConfiguration;
import software.amazon.awssdk.services.qldb.model.QldbRequest;
import software.amazon.awssdk.services.qldb.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamJournalToKinesisRequest
extends QldbRequest
implements ToCopyableBuilder<Builder, StreamJournalToKinesisRequest> {
    private static final SdkField<String> LEDGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LedgerName").getter(StreamJournalToKinesisRequest.getter(StreamJournalToKinesisRequest::ledgerName)).setter(StreamJournalToKinesisRequest.setter(Builder::ledgerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(StreamJournalToKinesisRequest.getter(StreamJournalToKinesisRequest::roleArn)).setter(StreamJournalToKinesisRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StreamJournalToKinesisRequest.getter(StreamJournalToKinesisRequest::tags)).setter(StreamJournalToKinesisRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InclusiveStartTime").getter(StreamJournalToKinesisRequest.getter(StreamJournalToKinesisRequest::inclusiveStartTime)).setter(StreamJournalToKinesisRequest.setter(Builder::inclusiveStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build()}).build();
    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExclusiveEndTime").getter(StreamJournalToKinesisRequest.getter(StreamJournalToKinesisRequest::exclusiveEndTime)).setter(StreamJournalToKinesisRequest.setter(Builder::exclusiveEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()}).build();
    private static final SdkField<KinesisConfiguration> KINESIS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisConfiguration").getter(StreamJournalToKinesisRequest.getter(StreamJournalToKinesisRequest::kinesisConfiguration)).setter(StreamJournalToKinesisRequest.setter(Builder::kinesisConfiguration)).constructor(KinesisConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisConfiguration").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(StreamJournalToKinesisRequest.getter(StreamJournalToKinesisRequest::streamName)).setter(StreamJournalToKinesisRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGER_NAME_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD, KINESIS_CONFIGURATION_FIELD, STREAM_NAME_FIELD));
    private final String ledgerName;
    private final String roleArn;
    private final Map<String, String> tags;
    private final Instant inclusiveStartTime;
    private final Instant exclusiveEndTime;
    private final KinesisConfiguration kinesisConfiguration;
    private final String streamName;

    private StreamJournalToKinesisRequest(BuilderImpl builder) {
        super(builder);
        this.ledgerName = builder.ledgerName;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.kinesisConfiguration = builder.kinesisConfiguration;
        this.streamName = builder.streamName;
    }

    public final String ledgerName() {
        return this.ledgerName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant inclusiveStartTime() {
        return this.inclusiveStartTime;
    }

    public final Instant exclusiveEndTime() {
        return this.exclusiveEndTime;
    }

    public final KinesisConfiguration kinesisConfiguration() {
        return this.kinesisConfiguration;
    }

    public final String streamName() {
        return this.streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ledgerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamJournalToKinesisRequest)) {
            return false;
        }
        StreamJournalToKinesisRequest other = (StreamJournalToKinesisRequest)((Object)obj);
        return Objects.equals(this.ledgerName(), other.ledgerName()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.inclusiveStartTime(), other.inclusiveStartTime()) && Objects.equals(this.exclusiveEndTime(), other.exclusiveEndTime()) && Objects.equals(this.kinesisConfiguration(), other.kinesisConfiguration()) && Objects.equals(this.streamName(), other.streamName());
    }

    public final String toString() {
        return ToString.builder((String)"StreamJournalToKinesisRequest").add("LedgerName", (Object)this.ledgerName()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("InclusiveStartTime", (Object)this.inclusiveStartTime()).add("ExclusiveEndTime", (Object)this.exclusiveEndTime()).add("KinesisConfiguration", (Object)this.kinesisConfiguration()).add("StreamName", (Object)this.streamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LedgerName": {
                return Optional.ofNullable(clazz.cast(this.ledgerName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "InclusiveStartTime": {
                return Optional.ofNullable(clazz.cast(this.inclusiveStartTime()));
            }
            case "ExclusiveEndTime": {
                return Optional.ofNullable(clazz.cast(this.exclusiveEndTime()));
            }
            case "KinesisConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisConfiguration()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamJournalToKinesisRequest, T> g) {
        return obj -> g.apply((StreamJournalToKinesisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbRequest.BuilderImpl
    implements Builder {
        private String ledgerName;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant inclusiveStartTime;
        private Instant exclusiveEndTime;
        private KinesisConfiguration kinesisConfiguration;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamJournalToKinesisRequest model) {
            super(model);
            this.ledgerName(model.ledgerName);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.inclusiveStartTime(model.inclusiveStartTime);
            this.exclusiveEndTime(model.exclusiveEndTime);
            this.kinesisConfiguration(model.kinesisConfiguration);
            this.streamName(model.streamName);
        }

        public final String getLedgerName() {
            return this.ledgerName;
        }

        public final void setLedgerName(String ledgerName) {
            this.ledgerName = ledgerName;
        }

        @Override
        @Transient
        public final Builder ledgerName(String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getInclusiveStartTime() {
            return this.inclusiveStartTime;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        @Override
        @Transient
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final Instant getExclusiveEndTime() {
            return this.exclusiveEndTime;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        @Override
        @Transient
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final KinesisConfiguration.Builder getKinesisConfiguration() {
            return this.kinesisConfiguration != null ? this.kinesisConfiguration.toBuilder() : null;
        }

        public final void setKinesisConfiguration(KinesisConfiguration.BuilderImpl kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration != null ? kinesisConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisConfiguration(KinesisConfiguration kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration;
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        @Transient
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StreamJournalToKinesisRequest build() {
            return new StreamJournalToKinesisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StreamJournalToKinesisRequest> {
        public Builder ledgerName(String var1);

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder inclusiveStartTime(Instant var1);

        public Builder exclusiveEndTime(Instant var1);

        public Builder kinesisConfiguration(KinesisConfiguration var1);

        default public Builder kinesisConfiguration(Consumer<KinesisConfiguration.Builder> kinesisConfiguration) {
            return this.kinesisConfiguration((KinesisConfiguration)((KinesisConfiguration.Builder)KinesisConfiguration.builder().applyMutation(kinesisConfiguration)).build());
        }

        public Builder streamName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

