/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.QldbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJournalKinesisStreamsForLedgerRequest
extends QldbRequest
implements ToCopyableBuilder<Builder, ListJournalKinesisStreamsForLedgerRequest> {
    private static final SdkField<String> LEDGER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LedgerName").getter(ListJournalKinesisStreamsForLedgerRequest.getter(ListJournalKinesisStreamsForLedgerRequest::ledgerName)).setter(ListJournalKinesisStreamsForLedgerRequest.setter(Builder::ledgerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListJournalKinesisStreamsForLedgerRequest.getter(ListJournalKinesisStreamsForLedgerRequest::maxResults)).setter(ListJournalKinesisStreamsForLedgerRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max_results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListJournalKinesisStreamsForLedgerRequest.getter(ListJournalKinesisStreamsForLedgerRequest::nextToken)).setter(ListJournalKinesisStreamsForLedgerRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next_token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGER_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String ledgerName;
    private final Integer maxResults;
    private final String nextToken;

    private ListJournalKinesisStreamsForLedgerRequest(BuilderImpl builder) {
        super(builder);
        this.ledgerName = builder.ledgerName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String ledgerName() {
        return this.ledgerName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ledgerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJournalKinesisStreamsForLedgerRequest)) {
            return false;
        }
        ListJournalKinesisStreamsForLedgerRequest other = (ListJournalKinesisStreamsForLedgerRequest)((Object)obj);
        return Objects.equals(this.ledgerName(), other.ledgerName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJournalKinesisStreamsForLedgerRequest").add("LedgerName", (Object)this.ledgerName()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LedgerName": {
                return Optional.ofNullable(clazz.cast(this.ledgerName()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJournalKinesisStreamsForLedgerRequest, T> g) {
        return obj -> g.apply((ListJournalKinesisStreamsForLedgerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbRequest.BuilderImpl
    implements Builder {
        private String ledgerName;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJournalKinesisStreamsForLedgerRequest model) {
            super(model);
            this.ledgerName(model.ledgerName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getLedgerName() {
            return this.ledgerName;
        }

        public final void setLedgerName(String ledgerName) {
            this.ledgerName = ledgerName;
        }

        @Override
        @Transient
        public final Builder ledgerName(String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJournalKinesisStreamsForLedgerRequest build() {
            return new ListJournalKinesisStreamsForLedgerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QldbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJournalKinesisStreamsForLedgerRequest> {
        public Builder ledgerName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

