/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.qldb.DefaultQldbAsyncClient;
import software.amazon.awssdk.services.qldb.DefaultQldbBaseClientBuilder;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.qldb.QldbAsyncClientBuilder;
import software.amazon.awssdk.services.qldb.QldbServiceClientConfiguration;
import software.amazon.awssdk.services.qldb.endpoints.QldbEndpointProvider;

@SdkInternalApi
final class DefaultQldbAsyncClientBuilder
extends DefaultQldbBaseClientBuilder<QldbAsyncClientBuilder, QldbAsyncClient>
implements QldbAsyncClientBuilder {
    DefaultQldbAsyncClientBuilder() {
    }

    @Override
    public DefaultQldbAsyncClientBuilder endpointProvider(QldbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QldbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultQldbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        QldbServiceClientConfiguration serviceClientConfiguration = QldbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultQldbAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

