/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJournalKinesisStreamsForLedgerResponse extends QldbResponse implements
        ToCopyableBuilder<ListJournalKinesisStreamsForLedgerResponse.Builder, ListJournalKinesisStreamsForLedgerResponse> {
    private static final SdkField<List<JournalKinesisStreamDescription>> STREAMS_FIELD = SdkField
            .<List<JournalKinesisStreamDescription>> builder(MarshallingType.LIST)
            .memberName("Streams")
            .getter(getter(ListJournalKinesisStreamsForLedgerResponse::streams))
            .setter(setter(Builder::streams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Streams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JournalKinesisStreamDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(JournalKinesisStreamDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListJournalKinesisStreamsForLedgerResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<JournalKinesisStreamDescription> streams;

    private final String nextToken;

    private ListJournalKinesisStreamsForLedgerResponse(BuilderImpl builder) {
        super(builder);
        this.streams = builder.streams;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Streams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreams() {
        return streams != null && !(streams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The QLDB journal streams that are currently associated with the given ledger.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreams} method.
     * </p>
     * 
     * @return The QLDB journal streams that are currently associated with the given ledger.
     */
    public final List<JournalKinesisStreamDescription> streams() {
        return streams;
    }

    /**
     * <ul>
     * <li>
     * <p>
     * If <code>NextToken</code> is empty, the last page of results has been processed and there are no more results to
     * be retrieved.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>NextToken</code> is <i>not</i> empty, more results are available. To retrieve the next page of results,
     * use the value of <code>NextToken</code> in a subsequent <code>ListJournalKinesisStreamsForLedger</code> call.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <li>
     *         <p>
     *         If <code>NextToken</code> is empty, the last page of results has been processed and there are no more
     *         results to be retrieved.
     *         </p>
     *         </li> <li>
     *         <p>
     *         If <code>NextToken</code> is <i>not</i> empty, more results are available. To retrieve the next page of
     *         results, use the value of <code>NextToken</code> in a subsequent
     *         <code>ListJournalKinesisStreamsForLedger</code> call.
     *         </p>
     *         </li>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStreams() ? streams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJournalKinesisStreamsForLedgerResponse)) {
            return false;
        }
        ListJournalKinesisStreamsForLedgerResponse other = (ListJournalKinesisStreamsForLedgerResponse) obj;
        return hasStreams() == other.hasStreams() && Objects.equals(streams(), other.streams())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJournalKinesisStreamsForLedgerResponse").add("Streams", hasStreams() ? streams() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Streams":
            return Optional.ofNullable(clazz.cast(streams()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJournalKinesisStreamsForLedgerResponse, T> g) {
        return obj -> g.apply((ListJournalKinesisStreamsForLedgerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListJournalKinesisStreamsForLedgerResponse> {
        /**
         * <p>
         * The QLDB journal streams that are currently associated with the given ledger.
         * </p>
         * 
         * @param streams
         *        The QLDB journal streams that are currently associated with the given ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<JournalKinesisStreamDescription> streams);

        /**
         * <p>
         * The QLDB journal streams that are currently associated with the given ledger.
         * </p>
         * 
         * @param streams
         *        The QLDB journal streams that are currently associated with the given ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(JournalKinesisStreamDescription... streams);

        /**
         * <p>
         * The QLDB journal streams that are currently associated with the given ledger.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #streams(List<JournalKinesisStreamDescription>)}.
         * 
         * @param streams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(java.util.Collection<JournalKinesisStreamDescription>)
         */
        Builder streams(Consumer<JournalKinesisStreamDescription.Builder>... streams);

        /**
         * <ul>
         * <li>
         * <p>
         * If <code>NextToken</code> is empty, the last page of results has been processed and there are no more results
         * to be retrieved.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>NextToken</code> is <i>not</i> empty, more results are available. To retrieve the next page of
         * results, use the value of <code>NextToken</code> in a subsequent
         * <code>ListJournalKinesisStreamsForLedger</code> call.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nextToken
         *        <li>
         *        <p>
         *        If <code>NextToken</code> is empty, the last page of results has been processed and there are no more
         *        results to be retrieved.
         *        </p>
         *        </li> <li>
         *        <p>
         *        If <code>NextToken</code> is <i>not</i> empty, more results are available. To retrieve the next page
         *        of results, use the value of <code>NextToken</code> in a subsequent
         *        <code>ListJournalKinesisStreamsForLedger</code> call.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private List<JournalKinesisStreamDescription> streams = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJournalKinesisStreamsForLedgerResponse model) {
            super(model);
            streams(model.streams);
            nextToken(model.nextToken);
        }

        public final List<JournalKinesisStreamDescription.Builder> getStreams() {
            List<JournalKinesisStreamDescription.Builder> result = JournalKinesisStreamDescriptionListCopier
                    .copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<JournalKinesisStreamDescription.BuilderImpl> streams) {
            this.streams = JournalKinesisStreamDescriptionListCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<JournalKinesisStreamDescription> streams) {
            this.streams = JournalKinesisStreamDescriptionListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(JournalKinesisStreamDescription... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<JournalKinesisStreamDescription.Builder>... streams) {
            streams(Stream.of(streams).map(c -> JournalKinesisStreamDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJournalKinesisStreamsForLedgerResponse build() {
            return new ListJournalKinesisStreamsForLedgerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
