/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.qldb.internal.UserAgentUtils;
import software.amazon.awssdk.services.qldb.model.ListLedgersRequest;
import software.amazon.awssdk.services.qldb.model.ListLedgersResponse;

public class ListLedgersPublisher
implements SdkPublisher<ListLedgersResponse> {
    private final QldbAsyncClient client;
    private final ListLedgersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLedgersPublisher(QldbAsyncClient client, ListLedgersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLedgersPublisher(QldbAsyncClient client, ListLedgersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLedgersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLedgersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLedgersResponseFetcher
    implements AsyncPageFetcher<ListLedgersResponse> {
        private ListLedgersResponseFetcher() {
        }

        public boolean hasNextPage(ListLedgersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLedgersResponse> nextPage(ListLedgersResponse previousPage) {
            if (previousPage == null) {
                return ListLedgersPublisher.this.client.listLedgers(ListLedgersPublisher.this.firstRequest);
            }
            return ListLedgersPublisher.this.client.listLedgers((ListLedgersRequest)((Object)ListLedgersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

