/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qldb.model.LedgerListCopier;
import software.amazon.awssdk.services.qldb.model.LedgerSummary;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLedgersResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, ListLedgersResponse> {
    private static final SdkField<List<LedgerSummary>> LEDGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ledgers").getter(ListLedgersResponse.getter(ListLedgersResponse::ledgers)).setter(ListLedgersResponse.setter(Builder::ledgers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ledgers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LedgerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLedgersResponse.getter(ListLedgersResponse::nextToken)).setter(ListLedgersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLedgersResponse.memberNameToFieldInitializer();
    private final List<LedgerSummary> ledgers;
    private final String nextToken;

    private ListLedgersResponse(BuilderImpl builder) {
        super(builder);
        this.ledgers = builder.ledgers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLedgers() {
        return this.ledgers != null && !(this.ledgers instanceof SdkAutoConstructList);
    }

    public final List<LedgerSummary> ledgers() {
        return this.ledgers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLedgers() ? this.ledgers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLedgersResponse)) {
            return false;
        }
        ListLedgersResponse other = (ListLedgersResponse)((Object)obj);
        return this.hasLedgers() == other.hasLedgers() && Objects.equals(this.ledgers(), other.ledgers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLedgersResponse").add("Ledgers", this.hasLedgers() ? this.ledgers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ledgers": {
                return Optional.ofNullable(clazz.cast(this.ledgers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Ledgers", LEDGERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLedgersResponse, T> g) {
        return obj -> g.apply((ListLedgersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private List<LedgerSummary> ledgers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLedgersResponse model) {
            super(model);
            this.ledgers(model.ledgers);
            this.nextToken(model.nextToken);
        }

        public final List<LedgerSummary.Builder> getLedgers() {
            List<LedgerSummary.Builder> result = LedgerListCopier.copyToBuilder(this.ledgers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLedgers(Collection<LedgerSummary.BuilderImpl> ledgers) {
            this.ledgers = LedgerListCopier.copyFromBuilder(ledgers);
        }

        @Override
        public final Builder ledgers(Collection<LedgerSummary> ledgers) {
            this.ledgers = LedgerListCopier.copy(ledgers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ledgers(LedgerSummary ... ledgers) {
            this.ledgers(Arrays.asList(ledgers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ledgers(Consumer<LedgerSummary.Builder> ... ledgers) {
            this.ledgers(Stream.of(ledgers).map(c -> (LedgerSummary)((LedgerSummary.Builder)LedgerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLedgersResponse build() {
            return new ListLedgersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLedgersResponse> {
        public Builder ledgers(Collection<LedgerSummary> var1);

        public Builder ledgers(LedgerSummary ... var1);

        public Builder ledgers(Consumer<LedgerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

