/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.JournalKinesisStreamDescription;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJournalKinesisStreamResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, DescribeJournalKinesisStreamResponse> {
    private static final SdkField<JournalKinesisStreamDescription> STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Stream").getter(DescribeJournalKinesisStreamResponse.getter(DescribeJournalKinesisStreamResponse::stream)).setter(DescribeJournalKinesisStreamResponse.setter(Builder::stream)).constructor(JournalKinesisStreamDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeJournalKinesisStreamResponse.memberNameToFieldInitializer();
    private final JournalKinesisStreamDescription stream;

    private DescribeJournalKinesisStreamResponse(BuilderImpl builder) {
        super(builder);
        this.stream = builder.stream;
    }

    public final JournalKinesisStreamDescription stream() {
        return this.stream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJournalKinesisStreamResponse)) {
            return false;
        }
        DescribeJournalKinesisStreamResponse other = (DescribeJournalKinesisStreamResponse)((Object)obj);
        return Objects.equals(this.stream(), other.stream());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeJournalKinesisStreamResponse").add("Stream", (Object)this.stream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Stream": {
                return Optional.ofNullable(clazz.cast(this.stream()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<JournalKinesisStreamDescription>> map = new HashMap<String, SdkField<JournalKinesisStreamDescription>>();
        map.put("Stream", STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeJournalKinesisStreamResponse, T> g) {
        return obj -> g.apply((DescribeJournalKinesisStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private JournalKinesisStreamDescription stream;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJournalKinesisStreamResponse model) {
            super(model);
            this.stream(model.stream);
        }

        public final JournalKinesisStreamDescription.Builder getStream() {
            return this.stream != null ? this.stream.toBuilder() : null;
        }

        public final void setStream(JournalKinesisStreamDescription.BuilderImpl stream) {
            this.stream = stream != null ? stream.build() : null;
        }

        @Override
        public final Builder stream(JournalKinesisStreamDescription stream) {
            this.stream = stream;
            return this;
        }

        @Override
        public DescribeJournalKinesisStreamResponse build() {
            return new DescribeJournalKinesisStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJournalKinesisStreamResponse> {
        public Builder stream(JournalKinesisStreamDescription var1);

        default public Builder stream(Consumer<JournalKinesisStreamDescription.Builder> stream) {
            return this.stream((JournalKinesisStreamDescription)((JournalKinesisStreamDescription.Builder)JournalKinesisStreamDescription.builder().applyMutation(stream)).build());
        }
    }
}

