/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.qldb.QldbClient;
import software.amazon.awssdk.services.qldb.QldbServiceClientConfiguration;
import software.amazon.awssdk.services.qldb.internal.QldbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamRequest;
import software.amazon.awssdk.services.qldb.model.CancelJournalKinesisStreamResponse;
import software.amazon.awssdk.services.qldb.model.CreateLedgerRequest;
import software.amazon.awssdk.services.qldb.model.CreateLedgerResponse;
import software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest;
import software.amazon.awssdk.services.qldb.model.DeleteLedgerResponse;
import software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamRequest;
import software.amazon.awssdk.services.qldb.model.DescribeJournalKinesisStreamResponse;
import software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportRequest;
import software.amazon.awssdk.services.qldb.model.DescribeJournalS3ExportResponse;
import software.amazon.awssdk.services.qldb.model.DescribeLedgerRequest;
import software.amazon.awssdk.services.qldb.model.DescribeLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ExportJournalToS3Request;
import software.amazon.awssdk.services.qldb.model.ExportJournalToS3Response;
import software.amazon.awssdk.services.qldb.model.GetBlockRequest;
import software.amazon.awssdk.services.qldb.model.GetBlockResponse;
import software.amazon.awssdk.services.qldb.model.GetDigestRequest;
import software.amazon.awssdk.services.qldb.model.GetDigestResponse;
import software.amazon.awssdk.services.qldb.model.GetRevisionRequest;
import software.amazon.awssdk.services.qldb.model.GetRevisionResponse;
import software.amazon.awssdk.services.qldb.model.InvalidParameterException;
import software.amazon.awssdk.services.qldb.model.LimitExceededException;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsForLedgerResponse;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsRequest;
import software.amazon.awssdk.services.qldb.model.ListJournalS3ExportsResponse;
import software.amazon.awssdk.services.qldb.model.ListLedgersRequest;
import software.amazon.awssdk.services.qldb.model.ListLedgersResponse;
import software.amazon.awssdk.services.qldb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qldb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qldb.model.QldbException;
import software.amazon.awssdk.services.qldb.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.qldb.model.ResourceInUseException;
import software.amazon.awssdk.services.qldb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qldb.model.ResourcePreconditionNotMetException;
import software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisRequest;
import software.amazon.awssdk.services.qldb.model.StreamJournalToKinesisResponse;
import software.amazon.awssdk.services.qldb.model.TagResourceRequest;
import software.amazon.awssdk.services.qldb.model.TagResourceResponse;
import software.amazon.awssdk.services.qldb.model.UntagResourceRequest;
import software.amazon.awssdk.services.qldb.model.UntagResourceResponse;
import software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeRequest;
import software.amazon.awssdk.services.qldb.model.UpdateLedgerPermissionsModeResponse;
import software.amazon.awssdk.services.qldb.model.UpdateLedgerRequest;
import software.amazon.awssdk.services.qldb.model.UpdateLedgerResponse;
import software.amazon.awssdk.services.qldb.transform.CancelJournalKinesisStreamRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.CreateLedgerRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.DeleteLedgerRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.DescribeJournalKinesisStreamRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.DescribeJournalS3ExportRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.DescribeLedgerRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.ExportJournalToS3RequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.GetBlockRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.GetDigestRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.GetRevisionRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.ListJournalKinesisStreamsForLedgerRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.ListJournalS3ExportsForLedgerRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.ListJournalS3ExportsRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.ListLedgersRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.StreamJournalToKinesisRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.UpdateLedgerPermissionsModeRequestMarshaller;
import software.amazon.awssdk.services.qldb.transform.UpdateLedgerRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultQldbClient
implements QldbClient {
    private static final Logger log = Logger.loggerFor(DefaultQldbClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQldbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"QLDB#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJournalKinesisStreamResponse cancelJournalKinesisStream(CancelJournalKinesisStreamRequest cancelJournalKinesisStreamRequest) throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelJournalKinesisStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelJournalKinesisStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, cancelJournalKinesisStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelJournalKinesisStream");
            CancelJournalKinesisStreamResponse cancelJournalKinesisStreamResponse = (CancelJournalKinesisStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelJournalKinesisStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelJournalKinesisStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelJournalKinesisStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelJournalKinesisStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$cancelJournalKinesisStream$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLedgerResponse createLedger(CreateLedgerRequest createLedgerRequest) throws InvalidParameterException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLedgerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLedgerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, createLedgerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLedger");
            CreateLedgerResponse createLedgerResponse = (CreateLedgerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLedger").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLedgerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLedgerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLedgerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$createLedger$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLedgerResponse deleteLedger(DeleteLedgerRequest deleteLedgerRequest) throws InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLedgerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLedgerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, deleteLedgerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLedger");
            DeleteLedgerResponse deleteLedgerResponse = (DeleteLedgerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLedger").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLedgerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLedgerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLedgerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$deleteLedger$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJournalKinesisStreamResponse describeJournalKinesisStream(DescribeJournalKinesisStreamRequest describeJournalKinesisStreamRequest) throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJournalKinesisStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJournalKinesisStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, describeJournalKinesisStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJournalKinesisStream");
            DescribeJournalKinesisStreamResponse describeJournalKinesisStreamResponse = (DescribeJournalKinesisStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJournalKinesisStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeJournalKinesisStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJournalKinesisStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJournalKinesisStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$describeJournalKinesisStream$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJournalS3ExportResponse describeJournalS3Export(DescribeJournalS3ExportRequest describeJournalS3ExportRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJournalS3ExportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeJournalS3ExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, describeJournalS3ExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJournalS3Export");
            DescribeJournalS3ExportResponse describeJournalS3ExportResponse = (DescribeJournalS3ExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJournalS3Export").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeJournalS3ExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJournalS3ExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJournalS3ExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$describeJournalS3Export$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLedgerResponse describeLedger(DescribeLedgerRequest describeLedgerRequest) throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLedgerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLedgerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, describeLedgerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLedger");
            DescribeLedgerResponse describeLedgerResponse = (DescribeLedgerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLedger").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLedgerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLedgerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLedgerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$describeLedger$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportJournalToS3Response exportJournalToS3(ExportJournalToS3Request exportJournalToS3Request) throws ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportJournalToS3Response::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportJournalToS3Request, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, exportJournalToS3Request.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportJournalToS3");
            ExportJournalToS3Response exportJournalToS3Response = (ExportJournalToS3Response)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportJournalToS3").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)exportJournalToS3Request).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportJournalToS3RequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportJournalToS3Response;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$exportJournalToS3$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBlockResponse getBlock(GetBlockRequest getBlockRequest) throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlockResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBlockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, getBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlock");
            GetBlockResponse getBlockResponse = (GetBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBlockRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBlockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBlockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$getBlock$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDigestResponse getDigest(GetDigestRequest getDigestRequest) throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDigestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDigestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, getDigestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDigest");
            GetDigestResponse getDigestResponse = (GetDigestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDigest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDigestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDigestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDigestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$getDigest$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRevisionResponse getRevision(GetRevisionRequest getRevisionRequest) throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRevisionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRevisionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, getRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRevision");
            GetRevisionResponse getRevisionResponse = (GetRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRevision").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRevisionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRevisionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$getRevision$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJournalKinesisStreamsForLedgerResponse listJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerRequest listJournalKinesisStreamsForLedgerRequest) throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJournalKinesisStreamsForLedgerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJournalKinesisStreamsForLedgerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, listJournalKinesisStreamsForLedgerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJournalKinesisStreamsForLedger");
            ListJournalKinesisStreamsForLedgerResponse listJournalKinesisStreamsForLedgerResponse = (ListJournalKinesisStreamsForLedgerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJournalKinesisStreamsForLedger").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJournalKinesisStreamsForLedgerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJournalKinesisStreamsForLedgerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJournalKinesisStreamsForLedgerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$listJournalKinesisStreamsForLedger$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJournalS3ExportsResponse listJournalS3Exports(ListJournalS3ExportsRequest listJournalS3ExportsRequest) throws AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJournalS3ExportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJournalS3ExportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, listJournalS3ExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJournalS3Exports");
            ListJournalS3ExportsResponse listJournalS3ExportsResponse = (ListJournalS3ExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJournalS3Exports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJournalS3ExportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJournalS3ExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJournalS3ExportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$listJournalS3Exports$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJournalS3ExportsForLedgerResponse listJournalS3ExportsForLedger(ListJournalS3ExportsForLedgerRequest listJournalS3ExportsForLedgerRequest) throws AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJournalS3ExportsForLedgerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJournalS3ExportsForLedgerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, listJournalS3ExportsForLedgerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJournalS3ExportsForLedger");
            ListJournalS3ExportsForLedgerResponse listJournalS3ExportsForLedgerResponse = (ListJournalS3ExportsForLedgerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJournalS3ExportsForLedger").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listJournalS3ExportsForLedgerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListJournalS3ExportsForLedgerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listJournalS3ExportsForLedgerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$listJournalS3ExportsForLedger$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLedgersResponse listLedgers(ListLedgersRequest listLedgersRequest) throws AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLedgersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLedgersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, listLedgersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLedgers");
            ListLedgersResponse listLedgersResponse = (ListLedgersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLedgers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listLedgersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLedgersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLedgersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$listLedgers$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$listTagsForResource$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamJournalToKinesisResponse streamJournalToKinesis(StreamJournalToKinesisRequest streamJournalToKinesisRequest) throws InvalidParameterException, ResourceNotFoundException, ResourcePreconditionNotMetException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StreamJournalToKinesisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)streamJournalToKinesisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, streamJournalToKinesisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StreamJournalToKinesis");
            StreamJournalToKinesisResponse streamJournalToKinesisResponse = (StreamJournalToKinesisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StreamJournalToKinesis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)streamJournalToKinesisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StreamJournalToKinesisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return streamJournalToKinesisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$streamJournalToKinesis$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$tagResource$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$untagResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLedgerResponse updateLedger(UpdateLedgerRequest updateLedgerRequest) throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLedgerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLedgerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, updateLedgerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLedger");
            UpdateLedgerResponse updateLedgerResponse = (UpdateLedgerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLedger").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateLedgerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLedgerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLedgerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$updateLedger$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLedgerPermissionsModeResponse updateLedgerPermissionsMode(UpdateLedgerPermissionsModeRequest updateLedgerPermissionsModeRequest) throws InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, QldbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLedgerPermissionsModeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ResourcePreconditionNotMetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePreconditionNotMetException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(ResourcePreconditionNotMetException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLedgerPermissionsModeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultQldbClient.resolveMetricPublishers(clientConfiguration, updateLedgerPermissionsModeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"QLDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLedgerPermissionsMode");
            UpdateLedgerPermissionsModeResponse updateLedgerPermissionsModeResponse = (UpdateLedgerPermissionsModeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLedgerPermissionsMode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateLedgerPermissionsModeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLedgerPermissionsModeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLedgerPermissionsModeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultQldbClient.lambda$updateLedgerPermissionsMode$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "qldb";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        QldbServiceClientConfigurationBuilder serviceConfigBuilder = new QldbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(QldbException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.0");
    }

    @Override
    public final QldbServiceClientConfiguration serviceClientConfiguration() {
        return new QldbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateLedgerPermissionsMode$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLedger$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$streamJournalToKinesis$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLedgers$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJournalS3ExportsForLedger$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJournalS3Exports$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJournalKinesisStreamsForLedger$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRevision$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDigest$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBlock$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportJournalToS3$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLedger$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJournalS3Export$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJournalKinesisStream$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLedger$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLedger$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelJournalKinesisStream$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

