/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings of the Amazon Kinesis Data Streams destination for an Amazon QLDB journal stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisConfiguration.Builder, KinesisConfiguration> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(KinesisConfiguration::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<Boolean> AGGREGATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AggregationEnabled").getter(getter(KinesisConfiguration::aggregationEnabled))
            .setter(setter(Builder::aggregationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            AGGREGATION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final Boolean aggregationEnabled;

    private KinesisConfiguration(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.aggregationEnabled = builder.aggregationEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of
     * records sent per API call.
     * </p>
     * <p>
     * Default: <code>True</code>
     * </p>
     * <important>
     * <p>
     * Record aggregation has important implications for processing records and requires de-aggregation in your stream
     * consumer. To learn more, see <a
     * href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a> and <a
     * href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer
     * De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * </important>
     * 
     * @return Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
     *         number of records sent per API call.</p>
     *         <p>
     *         Default: <code>True</code>
     *         </p>
     *         <important>
     *         <p>
     *         Record aggregation has important implications for processing records and requires de-aggregation in your
     *         stream consumer. To learn more, see <a
     *         href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a> and
     *         <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer
     *         De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     *         </p>
     */
    public final Boolean aggregationEnabled() {
        return aggregationEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisConfiguration)) {
            return false;
        }
        KinesisConfiguration other = (KinesisConfiguration) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(aggregationEnabled(), other.aggregationEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisConfiguration").add("StreamArn", streamArn())
                .add("AggregationEnabled", aggregationEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "AggregationEnabled":
            return Optional.ofNullable(clazz.cast(aggregationEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamArn", STREAM_ARN_FIELD);
        map.put("AggregationEnabled", AGGREGATION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisConfiguration, T> g) {
        return obj -> g.apply((KinesisConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number
         * of records sent per API call.
         * </p>
         * <p>
         * Default: <code>True</code>
         * </p>
         * <important>
         * <p>
         * Record aggregation has important implications for processing records and requires de-aggregation in your
         * stream consumer. To learn more, see <a
         * href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a> and <a
         * href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer
         * De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
         * </p>
         * </important>
         * 
         * @param aggregationEnabled
         *        Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
         *        number of records sent per API call.</p>
         *        <p>
         *        Default: <code>True</code>
         *        </p>
         *        <important>
         *        <p>
         *        Record aggregation has important implications for processing records and requires de-aggregation in
         *        your stream consumer. To learn more, see <a
         *        href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts</a>
         *        and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">
         *        Consumer De-aggregation</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationEnabled(Boolean aggregationEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private Boolean aggregationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisConfiguration model) {
            streamArn(model.streamArn);
            aggregationEnabled(model.aggregationEnabled);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Boolean getAggregationEnabled() {
            return aggregationEnabled;
        }

        public final void setAggregationEnabled(Boolean aggregationEnabled) {
            this.aggregationEnabled = aggregationEnabled;
        }

        @Override
        public final Builder aggregationEnabled(Boolean aggregationEnabled) {
            this.aggregationEnabled = aggregationEnabled;
            return this;
        }

        @Override
        public KinesisConfiguration build() {
            return new KinesisConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
