/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about a journal export job, including the ledger name, export ID, when it was created, current
 * status, and its start and end time export parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JournalS3ExportDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<JournalS3ExportDescription.Builder, JournalS3ExportDescription> {
    private static final SdkField<String> LEDGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JournalS3ExportDescription::ledgerName)).setter(setter(Builder::ledgerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LedgerName").build()).build();

    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JournalS3ExportDescription::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportId").build()).build();

    private static final SdkField<Instant> EXPORT_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(JournalS3ExportDescription::exportCreationTime)).setter(setter(Builder::exportCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportCreationTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JournalS3ExportDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(JournalS3ExportDescription::inclusiveStartTime)).setter(setter(Builder::inclusiveStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build())
            .build();

    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(JournalS3ExportDescription::exclusiveEndTime)).setter(setter(Builder::exclusiveEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()).build();

    private static final SdkField<S3ExportConfiguration> S3_EXPORT_CONFIGURATION_FIELD = SdkField
            .<S3ExportConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(JournalS3ExportDescription::s3ExportConfiguration)).setter(setter(Builder::s3ExportConfiguration))
            .constructor(S3ExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JournalS3ExportDescription::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGER_NAME_FIELD,
            EXPORT_ID_FIELD, EXPORT_CREATION_TIME_FIELD, STATUS_FIELD, INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD,
            S3_EXPORT_CONFIGURATION_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ledgerName;

    private final String exportId;

    private final Instant exportCreationTime;

    private final String status;

    private final Instant inclusiveStartTime;

    private final Instant exclusiveEndTime;

    private final S3ExportConfiguration s3ExportConfiguration;

    private final String roleArn;

    private JournalS3ExportDescription(BuilderImpl builder) {
        this.ledgerName = builder.ledgerName;
        this.exportId = builder.exportId;
        this.exportCreationTime = builder.exportCreationTime;
        this.status = builder.status;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.s3ExportConfiguration = builder.s3ExportConfiguration;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public String ledgerName() {
        return ledgerName;
    }

    /**
     * <p>
     * The unique ID of the journal export job.
     * </p>
     * 
     * @return The unique ID of the journal export job.
     */
    public String exportId() {
        return exportId;
    }

    /**
     * <p>
     * The date and time, in epoch time format, when the export job was created. (Epoch time format is the number of
     * seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     * </p>
     * 
     * @return The date and time, in epoch time format, when the export job was created. (Epoch time format is the
     *         number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    public Instant exportCreationTime() {
        return exportCreationTime;
    }

    /**
     * <p>
     * The current state of the journal export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the journal export job.
     * @see ExportStatus
     */
    public ExportStatus status() {
        return ExportStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the journal export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the journal export job.
     * @see ExportStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The inclusive start date and time for the range of journal contents that are specified in the original export
     * request.
     * </p>
     * 
     * @return The inclusive start date and time for the range of journal contents that are specified in the original
     *         export request.
     */
    public Instant inclusiveStartTime() {
        return inclusiveStartTime;
    }

    /**
     * <p>
     * The exclusive end date and time for the range of journal contents that are specified in the original export
     * request.
     * </p>
     * 
     * @return The exclusive end date and time for the range of journal contents that are specified in the original
     *         export request.
     */
    public Instant exclusiveEndTime() {
        return exclusiveEndTime;
    }

    /**
     * Returns the value of the S3ExportConfiguration property for this object.
     * 
     * @return The value of the S3ExportConfiguration property for this object.
     */
    public S3ExportConfiguration s3ExportConfiguration() {
        return s3ExportConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side encryption
     * of your exported data.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to
     *         do the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side
     *         encryption of your exported data.
     *         </p>
     *         </li>
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ledgerName());
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(exportCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JournalS3ExportDescription)) {
            return false;
        }
        JournalS3ExportDescription other = (JournalS3ExportDescription) obj;
        return Objects.equals(ledgerName(), other.ledgerName()) && Objects.equals(exportId(), other.exportId())
                && Objects.equals(exportCreationTime(), other.exportCreationTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(inclusiveStartTime(), other.inclusiveStartTime())
                && Objects.equals(exclusiveEndTime(), other.exclusiveEndTime())
                && Objects.equals(s3ExportConfiguration(), other.s3ExportConfiguration())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JournalS3ExportDescription").add("LedgerName", ledgerName()).add("ExportId", exportId())
                .add("ExportCreationTime", exportCreationTime()).add("Status", statusAsString())
                .add("InclusiveStartTime", inclusiveStartTime()).add("ExclusiveEndTime", exclusiveEndTime())
                .add("S3ExportConfiguration", s3ExportConfiguration()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LedgerName":
            return Optional.ofNullable(clazz.cast(ledgerName()));
        case "ExportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "ExportCreationTime":
            return Optional.ofNullable(clazz.cast(exportCreationTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InclusiveStartTime":
            return Optional.ofNullable(clazz.cast(inclusiveStartTime()));
        case "ExclusiveEndTime":
            return Optional.ofNullable(clazz.cast(exclusiveEndTime()));
        case "S3ExportConfiguration":
            return Optional.ofNullable(clazz.cast(s3ExportConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JournalS3ExportDescription, T> g) {
        return obj -> g.apply((JournalS3ExportDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JournalS3ExportDescription> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param ledgerName
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ledgerName(String ledgerName);

        /**
         * <p>
         * The unique ID of the journal export job.
         * </p>
         * 
         * @param exportId
         *        The unique ID of the journal export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * The date and time, in epoch time format, when the export job was created. (Epoch time format is the number of
         * seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * </p>
         * 
         * @param exportCreationTime
         *        The date and time, in epoch time format, when the export job was created. (Epoch time format is the
         *        number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportCreationTime(Instant exportCreationTime);

        /**
         * <p>
         * The current state of the journal export job.
         * </p>
         * 
         * @param status
         *        The current state of the journal export job.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the journal export job.
         * </p>
         * 
         * @param status
         *        The current state of the journal export job.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder status(ExportStatus status);

        /**
         * <p>
         * The inclusive start date and time for the range of journal contents that are specified in the original export
         * request.
         * </p>
         * 
         * @param inclusiveStartTime
         *        The inclusive start date and time for the range of journal contents that are specified in the original
         *        export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusiveStartTime(Instant inclusiveStartTime);

        /**
         * <p>
         * The exclusive end date and time for the range of journal contents that are specified in the original export
         * request.
         * </p>
         * 
         * @param exclusiveEndTime
         *        The exclusive end date and time for the range of journal contents that are specified in the original
         *        export request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveEndTime(Instant exclusiveEndTime);

        /**
         * Sets the value of the S3ExportConfiguration property for this object.
         *
         * @param s3ExportConfiguration
         *        The new value for the S3ExportConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration);

        /**
         * Sets the value of the S3ExportConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3ExportConfiguration.Builder} avoiding the need
         * to create one manually via {@link S3ExportConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ExportConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3ExportConfiguration(S3ExportConfiguration)}.
         * 
         * @param s3ExportConfiguration
         *        a consumer that will call methods on {@link S3ExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ExportConfiguration(S3ExportConfiguration)
         */
        default Builder s3ExportConfiguration(Consumer<S3ExportConfiguration.Builder> s3ExportConfiguration) {
            return s3ExportConfiguration(S3ExportConfiguration.builder().applyMutation(s3ExportConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job to do
         * the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side
         * encryption of your exported data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal export job
         *        to do the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        (Optional) Use your customer master key (CMK) in AWS Key Management Service (AWS KMS) for server-side
         *        encryption of your exported data.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String ledgerName;

        private String exportId;

        private Instant exportCreationTime;

        private String status;

        private Instant inclusiveStartTime;

        private Instant exclusiveEndTime;

        private S3ExportConfiguration s3ExportConfiguration;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(JournalS3ExportDescription model) {
            ledgerName(model.ledgerName);
            exportId(model.exportId);
            exportCreationTime(model.exportCreationTime);
            status(model.status);
            inclusiveStartTime(model.inclusiveStartTime);
            exclusiveEndTime(model.exclusiveEndTime);
            s3ExportConfiguration(model.s3ExportConfiguration);
            roleArn(model.roleArn);
        }

        public final String getLedgerName() {
            return ledgerName;
        }

        @Override
        public final Builder ledgerName(String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        public final void setLedgerName(String ledgerName) {
            this.ledgerName = ledgerName;
        }

        public final String getExportId() {
            return exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        public final Instant getExportCreationTime() {
            return exportCreationTime;
        }

        @Override
        public final Builder exportCreationTime(Instant exportCreationTime) {
            this.exportCreationTime = exportCreationTime;
            return this;
        }

        public final void setExportCreationTime(Instant exportCreationTime) {
            this.exportCreationTime = exportCreationTime;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getInclusiveStartTime() {
            return inclusiveStartTime;
        }

        @Override
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        public final Instant getExclusiveEndTime() {
            return exclusiveEndTime;
        }

        @Override
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        public final S3ExportConfiguration.Builder getS3ExportConfiguration() {
            return s3ExportConfiguration != null ? s3ExportConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3ExportConfiguration(S3ExportConfiguration s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration;
            return this;
        }

        public final void setS3ExportConfiguration(S3ExportConfiguration.BuilderImpl s3ExportConfiguration) {
            this.s3ExportConfiguration = s3ExportConfiguration != null ? s3ExportConfiguration.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public JournalS3ExportDescription build() {
            return new JournalS3ExportDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
