/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the committed transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommitTransactionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<CommitTransactionResult.Builder, CommitTransactionResult> {
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CommitTransactionResult::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<SdkBytes> COMMIT_DIGEST_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(CommitTransactionResult::commitDigest)).setter(setter(Builder::commitDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitDigest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_ID_FIELD,
            COMMIT_DIGEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transactionId;

    private final SdkBytes commitDigest;

    private CommitTransactionResult(BuilderImpl builder) {
        this.transactionId = builder.transactionId;
        this.commitDigest = builder.commitDigest;
    }

    /**
     * <p>
     * The transaction id of the committed transaction.
     * </p>
     * 
     * @return The transaction id of the committed transaction.
     */
    public String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The commit digest of the committed transaction.
     * </p>
     * 
     * @return The commit digest of the committed transaction.
     */
    public SdkBytes commitDigest() {
        return commitDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(commitDigest());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitTransactionResult)) {
            return false;
        }
        CommitTransactionResult other = (CommitTransactionResult) obj;
        return Objects.equals(transactionId(), other.transactionId()) && Objects.equals(commitDigest(), other.commitDigest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CommitTransactionResult").add("TransactionId", transactionId())
                .add("CommitDigest", commitDigest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "CommitDigest":
            return Optional.ofNullable(clazz.cast(commitDigest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitTransactionResult, T> g) {
        return obj -> g.apply((CommitTransactionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommitTransactionResult> {
        /**
         * <p>
         * The transaction id of the committed transaction.
         * </p>
         * 
         * @param transactionId
         *        The transaction id of the committed transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The commit digest of the committed transaction.
         * </p>
         * 
         * @param commitDigest
         *        The commit digest of the committed transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitDigest(SdkBytes commitDigest);
    }

    static final class BuilderImpl implements Builder {
        private String transactionId;

        private SdkBytes commitDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitTransactionResult model) {
            transactionId(model.transactionId);
            commitDigest(model.commitDigest);
        }

        public final String getTransactionId() {
            return transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public final ByteBuffer getCommitDigest() {
            return commitDigest == null ? null : commitDigest.asByteBuffer();
        }

        @Override
        public final Builder commitDigest(SdkBytes commitDigest) {
            this.commitDigest = StandardMemberCopier.copy(commitDigest);
            return this;
        }

        public final void setCommitDigest(ByteBuffer commitDigest) {
            commitDigest(commitDigest == null ? null : SdkBytes.fromByteBuffer(commitDigest));
        }

        @Override
        public CommitTransactionResult build() {
            return new CommitTransactionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
