/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the started session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSessionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<StartSessionResult.Builder, StartSessionResult> {
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionToken").getter(getter(StartSessionResult::sessionToken)).setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sessionToken;

    private StartSessionResult(BuilderImpl builder) {
        this.sessionToken = builder.sessionToken;
    }

    /**
     * <p>
     * Session token of the started session. This <code>SessionToken</code> is required for every subsequent command
     * that is issued during the current session.
     * </p>
     * 
     * @return Session token of the started session. This <code>SessionToken</code> is required for every subsequent
     *         command that is issued during the current session.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionResult)) {
            return false;
        }
        StartSessionResult other = (StartSessionResult) obj;
        return Objects.equals(sessionToken(), other.sessionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSessionResult").add("SessionToken", sessionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSessionResult, T> g) {
        return obj -> g.apply((StartSessionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartSessionResult> {
        /**
         * <p>
         * Session token of the started session. This <code>SessionToken</code> is required for every subsequent command
         * that is issued during the current session.
         * </p>
         * 
         * @param sessionToken
         *        Session token of the started session. This <code>SessionToken</code> is required for every subsequent
         *        command that is issued during the current session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);
    }

    static final class BuilderImpl implements Builder {
        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionResult model) {
            sessionToken(model.sessionToken);
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public StartSessionResult build() {
            return new StartSessionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
