/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.qldbsession.model.SendCommandRequest;
import software.amazon.awssdk.services.qldbsession.model.SendCommandResponse;

/**
 * Service client for accessing QLDB Session asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The transactional data APIs for Amazon QLDB
 * </p>
 * <note>
 * <p>
 * Instead of interacting directly with this API, we recommend using the QLDB driver or the QLDB shell to execute data
 * transactions on a ledger.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If you are working with an AWS SDK, use the QLDB driver. The driver provides a high-level abstraction layer above
 * this <i>QLDB Session</i> data plane and manages <code>SendCommand</code> API calls for you. For information and a
 * list of supported programming languages, see <a
 * href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-driver.html">Getting started with the
 * driver</a> in the <i>Amazon QLDB Developer Guide</i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you are working with the AWS Command Line Interface (AWS CLI), use the QLDB shell. The shell is a command line
 * interface that uses the QLDB driver to interact with a ledger. For information, see <a
 * href="https://docs.aws.amazon.com/qldb/latest/developerguide/data-shell.html">Accessing Amazon QLDB using the QLDB
 * shell</a>.
 * </p>
 * </li>
 * </ul>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public interface QldbSessionAsyncClient extends SdkClient {
    String SERVICE_NAME = "qldb";

    /**
     * Create a {@link QldbSessionAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QldbSessionAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QldbSessionAsyncClient}.
     */
    static QldbSessionAsyncClientBuilder builder() {
        return new DefaultQldbSessionAsyncClientBuilder();
    }

    /**
     * <p>
     * Sends a command to an Amazon QLDB ledger.
     * </p>
     * <note>
     * <p>
     * Instead of interacting directly with this API, we recommend using the QLDB driver or the QLDB shell to execute
     * data transactions on a ledger.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are working with an AWS SDK, use the QLDB driver. The driver provides a high-level abstraction layer above
     * this <i>QLDB Session</i> data plane and manages <code>SendCommand</code> API calls for you. For information and a
     * list of supported programming languages, see <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-driver.html">Getting started with
     * the driver</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are working with the AWS Command Line Interface (AWS CLI), use the QLDB shell. The shell is a command line
     * interface that uses the QLDB driver to interact with a ledger. For information, see <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/data-shell.html">Accessing Amazon QLDB using the
     * QLDB shell</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param sendCommandRequest
     * @return A Java Future containing the result of the SendCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Returned if the request is malformed or contains an error such as an invalid
     *         parameter value or a missing required parameter.</li>
     *         <li>InvalidSessionException Returned if the session doesn't exist anymore because it timed out or
     *         expired.</li>
     *         <li>OccConflictException Returned when a transaction cannot be written to the journal due to a failure in
     *         the verification phase of <i>optimistic concurrency control</i> (OCC).</li>
     *         <li>RateExceededException Returned when the rate of requests exceeds the allowed throughput.</li>
     *         <li>LimitExceededException Returned if a resource limit such as number of active sessions is exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QldbSessionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QldbSessionAsyncClient.SendCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-session-2019-07-11/SendCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendCommandResponse> sendCommand(SendCommandRequest sendCommandRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a command to an Amazon QLDB ledger.
     * </p>
     * <note>
     * <p>
     * Instead of interacting directly with this API, we recommend using the QLDB driver or the QLDB shell to execute
     * data transactions on a ledger.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are working with an AWS SDK, use the QLDB driver. The driver provides a high-level abstraction layer above
     * this <i>QLDB Session</i> data plane and manages <code>SendCommand</code> API calls for you. For information and a
     * list of supported programming languages, see <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-driver.html">Getting started with
     * the driver</a> in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are working with the AWS Command Line Interface (AWS CLI), use the QLDB shell. The shell is a command line
     * interface that uses the QLDB driver to interact with a ledger. For information, see <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/data-shell.html">Accessing Amazon QLDB using the
     * QLDB shell</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendCommandRequest.Builder} avoiding the need to
     * create one manually via {@link SendCommandRequest#builder()}
     * </p>
     *
     * @param sendCommandRequest
     *        A {@link Consumer} that will call methods on {@link SendCommandRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException Returned if the request is malformed or contains an error such as an invalid
     *         parameter value or a missing required parameter.</li>
     *         <li>InvalidSessionException Returned if the session doesn't exist anymore because it timed out or
     *         expired.</li>
     *         <li>OccConflictException Returned when a transaction cannot be written to the journal due to a failure in
     *         the verification phase of <i>optimistic concurrency control</i> (OCC).</li>
     *         <li>RateExceededException Returned when the rate of requests exceeds the allowed throughput.</li>
     *         <li>LimitExceededException Returned if a resource limit such as number of active sessions is exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QldbSessionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QldbSessionAsyncClient.SendCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/qldb-session-2019-07-11/SendCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendCommandResponse> sendCommand(Consumer<SendCommandRequest.Builder> sendCommandRequest) {
        return sendCommand(SendCommandRequest.builder().applyMutation(sendCommandRequest).build());
    }
}
