/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of the fetched page.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Page implements SdkPojo, Serializable, ToCopyableBuilder<Page.Builder, Page> {
    private static final SdkField<List<ValueHolder>> VALUES_FIELD = SdkField
            .<List<ValueHolder>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(Page::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValueHolder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValueHolder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(Page::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValueHolder> values;

    private final String nextPageToken;

    private Page(BuilderImpl builder) {
        this.values = builder.values;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that contains values in multiple encoding formats.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A structure that contains values in multiple encoding formats.
     */
    public final List<ValueHolder> values() {
        return values;
    }

    /**
     * <p>
     * The token of the next page.
     * </p>
     * 
     * @return The token of the next page.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page) obj;
        return hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Page").add("Values", hasValues() ? values() : null).add("NextPageToken", nextPageToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Page, T> g) {
        return obj -> g.apply((Page) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Page> {
        /**
         * <p>
         * A structure that contains values in multiple encoding formats.
         * </p>
         * 
         * @param values
         *        A structure that contains values in multiple encoding formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<ValueHolder> values);

        /**
         * <p>
         * A structure that contains values in multiple encoding formats.
         * </p>
         * 
         * @param values
         *        A structure that contains values in multiple encoding formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(ValueHolder... values);

        /**
         * <p>
         * A structure that contains values in multiple encoding formats.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValueHolder>.Builder} avoiding the need to
         * create one manually via {@link List<ValueHolder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValueHolder>.Builder#build()} is called immediately and its
         * result is passed to {@link #values(List<ValueHolder>)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link List<ValueHolder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(List<ValueHolder>)
         */
        Builder values(Consumer<ValueHolder.Builder>... values);

        /**
         * <p>
         * The token of the next page.
         * </p>
         * 
         * @param nextPageToken
         *        The token of the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ValueHolder> values = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Page model) {
            values(model.values);
            nextPageToken(model.nextPageToken);
        }

        public final List<ValueHolder.Builder> getValues() {
            List<ValueHolder.Builder> result = ValueHoldersCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder values(Collection<ValueHolder> values) {
            this.values = ValueHoldersCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(ValueHolder... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<ValueHolder.Builder>... values) {
            values(Stream.of(values).map(c -> ValueHolder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValues(Collection<ValueHolder.BuilderImpl> values) {
            this.values = ValueHoldersCopier.copyFromBuilder(values);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Page build() {
            return new Page(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
