/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ValueHoldersCopier {
    static List<ValueHolder> copy(Collection<ValueHolder> valueHoldersParam) {
        if (valueHoldersParam == null || valueHoldersParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<ValueHolder> valueHoldersParamCopy = new ArrayList<>(valueHoldersParam);
        return Collections.unmodifiableList(valueHoldersParamCopy);
    }

    static List<ValueHolder> copyFromBuilder(Collection<? extends ValueHolder.Builder> valueHoldersParam) {
        if (valueHoldersParam == null || valueHoldersParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(valueHoldersParam.stream().map(ValueHolder.Builder::build).collect(toList()));
    }
}
