/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendCommandRequest extends QldbSessionRequest implements
        ToCopyableBuilder<SendCommandRequest.Builder, SendCommandRequest> {
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionToken").getter(getter(SendCommandRequest::sessionToken)).setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionToken").build()).build();

    private static final SdkField<StartSessionRequest> START_SESSION_FIELD = SdkField
            .<StartSessionRequest> builder(MarshallingType.SDK_POJO).memberName("StartSession")
            .getter(getter(SendCommandRequest::startSession)).setter(setter(Builder::startSession))
            .constructor(StartSessionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSession").build()).build();

    private static final SdkField<StartTransactionRequest> START_TRANSACTION_FIELD = SdkField
            .<StartTransactionRequest> builder(MarshallingType.SDK_POJO).memberName("StartTransaction")
            .getter(getter(SendCommandRequest::startTransaction)).setter(setter(Builder::startTransaction))
            .constructor(StartTransactionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTransaction").build()).build();

    private static final SdkField<EndSessionRequest> END_SESSION_FIELD = SdkField
            .<EndSessionRequest> builder(MarshallingType.SDK_POJO).memberName("EndSession")
            .getter(getter(SendCommandRequest::endSession)).setter(setter(Builder::endSession))
            .constructor(EndSessionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndSession").build()).build();

    private static final SdkField<CommitTransactionRequest> COMMIT_TRANSACTION_FIELD = SdkField
            .<CommitTransactionRequest> builder(MarshallingType.SDK_POJO).memberName("CommitTransaction")
            .getter(getter(SendCommandRequest::commitTransaction)).setter(setter(Builder::commitTransaction))
            .constructor(CommitTransactionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitTransaction").build()).build();

    private static final SdkField<AbortTransactionRequest> ABORT_TRANSACTION_FIELD = SdkField
            .<AbortTransactionRequest> builder(MarshallingType.SDK_POJO).memberName("AbortTransaction")
            .getter(getter(SendCommandRequest::abortTransaction)).setter(setter(Builder::abortTransaction))
            .constructor(AbortTransactionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortTransaction").build()).build();

    private static final SdkField<ExecuteStatementRequest> EXECUTE_STATEMENT_FIELD = SdkField
            .<ExecuteStatementRequest> builder(MarshallingType.SDK_POJO).memberName("ExecuteStatement")
            .getter(getter(SendCommandRequest::executeStatement)).setter(setter(Builder::executeStatement))
            .constructor(ExecuteStatementRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteStatement").build()).build();

    private static final SdkField<FetchPageRequest> FETCH_PAGE_FIELD = SdkField
            .<FetchPageRequest> builder(MarshallingType.SDK_POJO).memberName("FetchPage")
            .getter(getter(SendCommandRequest::fetchPage)).setter(setter(Builder::fetchPage))
            .constructor(FetchPageRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FetchPage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_TOKEN_FIELD,
            START_SESSION_FIELD, START_TRANSACTION_FIELD, END_SESSION_FIELD, COMMIT_TRANSACTION_FIELD, ABORT_TRANSACTION_FIELD,
            EXECUTE_STATEMENT_FIELD, FETCH_PAGE_FIELD));

    private final String sessionToken;

    private final StartSessionRequest startSession;

    private final StartTransactionRequest startTransaction;

    private final EndSessionRequest endSession;

    private final CommitTransactionRequest commitTransaction;

    private final AbortTransactionRequest abortTransaction;

    private final ExecuteStatementRequest executeStatement;

    private final FetchPageRequest fetchPage;

    private SendCommandRequest(BuilderImpl builder) {
        super(builder);
        this.sessionToken = builder.sessionToken;
        this.startSession = builder.startSession;
        this.startTransaction = builder.startTransaction;
        this.endSession = builder.endSession;
        this.commitTransaction = builder.commitTransaction;
        this.abortTransaction = builder.abortTransaction;
        this.executeStatement = builder.executeStatement;
        this.fetchPage = builder.fetchPage;
    }

    /**
     * <p>
     * Specifies the session token for the current command. A session token is constant throughout the life of the
     * session.
     * </p>
     * <p>
     * To obtain a session token, run the <code>StartSession</code> command. This <code>SessionToken</code> is required
     * for every subsequent command that is issued during the current session.
     * </p>
     * 
     * @return Specifies the session token for the current command. A session token is constant throughout the life of
     *         the session.</p>
     *         <p>
     *         To obtain a session token, run the <code>StartSession</code> command. This <code>SessionToken</code> is
     *         required for every subsequent command that is issued during the current session.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    /**
     * <p>
     * Command to start a new session. A session token is obtained as part of the response.
     * </p>
     * 
     * @return Command to start a new session. A session token is obtained as part of the response.
     */
    public final StartSessionRequest startSession() {
        return startSession;
    }

    /**
     * <p>
     * Command to start a new transaction.
     * </p>
     * 
     * @return Command to start a new transaction.
     */
    public final StartTransactionRequest startTransaction() {
        return startTransaction;
    }

    /**
     * <p>
     * Command to end the current session.
     * </p>
     * 
     * @return Command to end the current session.
     */
    public final EndSessionRequest endSession() {
        return endSession;
    }

    /**
     * <p>
     * Command to commit the specified transaction.
     * </p>
     * 
     * @return Command to commit the specified transaction.
     */
    public final CommitTransactionRequest commitTransaction() {
        return commitTransaction;
    }

    /**
     * <p>
     * Command to abort the current transaction.
     * </p>
     * 
     * @return Command to abort the current transaction.
     */
    public final AbortTransactionRequest abortTransaction() {
        return abortTransaction;
    }

    /**
     * <p>
     * Command to execute a statement in the specified transaction.
     * </p>
     * 
     * @return Command to execute a statement in the specified transaction.
     */
    public final ExecuteStatementRequest executeStatement() {
        return executeStatement;
    }

    /**
     * <p>
     * Command to fetch a page.
     * </p>
     * 
     * @return Command to fetch a page.
     */
    public final FetchPageRequest fetchPage() {
        return fetchPage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(startSession());
        hashCode = 31 * hashCode + Objects.hashCode(startTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(endSession());
        hashCode = 31 * hashCode + Objects.hashCode(commitTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(abortTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(executeStatement());
        hashCode = 31 * hashCode + Objects.hashCode(fetchPage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest) obj;
        return Objects.equals(sessionToken(), other.sessionToken()) && Objects.equals(startSession(), other.startSession())
                && Objects.equals(startTransaction(), other.startTransaction())
                && Objects.equals(endSession(), other.endSession())
                && Objects.equals(commitTransaction(), other.commitTransaction())
                && Objects.equals(abortTransaction(), other.abortTransaction())
                && Objects.equals(executeStatement(), other.executeStatement()) && Objects.equals(fetchPage(), other.fetchPage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendCommandRequest").add("SessionToken", sessionToken()).add("StartSession", startSession())
                .add("StartTransaction", startTransaction()).add("EndSession", endSession())
                .add("CommitTransaction", commitTransaction()).add("AbortTransaction", abortTransaction())
                .add("ExecuteStatement", executeStatement()).add("FetchPage", fetchPage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        case "StartSession":
            return Optional.ofNullable(clazz.cast(startSession()));
        case "StartTransaction":
            return Optional.ofNullable(clazz.cast(startTransaction()));
        case "EndSession":
            return Optional.ofNullable(clazz.cast(endSession()));
        case "CommitTransaction":
            return Optional.ofNullable(clazz.cast(commitTransaction()));
        case "AbortTransaction":
            return Optional.ofNullable(clazz.cast(abortTransaction()));
        case "ExecuteStatement":
            return Optional.ofNullable(clazz.cast(executeStatement()));
        case "FetchPage":
            return Optional.ofNullable(clazz.cast(fetchPage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendCommandRequest, T> g) {
        return obj -> g.apply((SendCommandRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbSessionRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendCommandRequest> {
        /**
         * <p>
         * Specifies the session token for the current command. A session token is constant throughout the life of the
         * session.
         * </p>
         * <p>
         * To obtain a session token, run the <code>StartSession</code> command. This <code>SessionToken</code> is
         * required for every subsequent command that is issued during the current session.
         * </p>
         * 
         * @param sessionToken
         *        Specifies the session token for the current command. A session token is constant throughout the life
         *        of the session.</p>
         *        <p>
         *        To obtain a session token, run the <code>StartSession</code> command. This <code>SessionToken</code>
         *        is required for every subsequent command that is issued during the current session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        /**
         * <p>
         * Command to start a new session. A session token is obtained as part of the response.
         * </p>
         * 
         * @param startSession
         *        Command to start a new session. A session token is obtained as part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSession(StartSessionRequest startSession);

        /**
         * <p>
         * Command to start a new session. A session token is obtained as part of the response.
         * </p>
         * This is a convenience that creates an instance of the {@link StartSessionRequest.Builder} avoiding the need
         * to create one manually via {@link StartSessionRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartSessionRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #startSession(StartSessionRequest)}.
         * 
         * @param startSession
         *        a consumer that will call methods on {@link StartSessionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startSession(StartSessionRequest)
         */
        default Builder startSession(Consumer<StartSessionRequest.Builder> startSession) {
            return startSession(StartSessionRequest.builder().applyMutation(startSession).build());
        }

        /**
         * <p>
         * Command to start a new transaction.
         * </p>
         * 
         * @param startTransaction
         *        Command to start a new transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTransaction(StartTransactionRequest startTransaction);

        /**
         * <p>
         * Command to start a new transaction.
         * </p>
         * This is a convenience that creates an instance of the {@link StartTransactionRequest.Builder} avoiding the
         * need to create one manually via {@link StartTransactionRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartTransactionRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #startTransaction(StartTransactionRequest)}.
         * 
         * @param startTransaction
         *        a consumer that will call methods on {@link StartTransactionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTransaction(StartTransactionRequest)
         */
        default Builder startTransaction(Consumer<StartTransactionRequest.Builder> startTransaction) {
            return startTransaction(StartTransactionRequest.builder().applyMutation(startTransaction).build());
        }

        /**
         * <p>
         * Command to end the current session.
         * </p>
         * 
         * @param endSession
         *        Command to end the current session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endSession(EndSessionRequest endSession);

        /**
         * <p>
         * Command to end the current session.
         * </p>
         * This is a convenience that creates an instance of the {@link EndSessionRequest.Builder} avoiding the need to
         * create one manually via {@link EndSessionRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndSessionRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #endSession(EndSessionRequest)}.
         * 
         * @param endSession
         *        a consumer that will call methods on {@link EndSessionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endSession(EndSessionRequest)
         */
        default Builder endSession(Consumer<EndSessionRequest.Builder> endSession) {
            return endSession(EndSessionRequest.builder().applyMutation(endSession).build());
        }

        /**
         * <p>
         * Command to commit the specified transaction.
         * </p>
         * 
         * @param commitTransaction
         *        Command to commit the specified transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitTransaction(CommitTransactionRequest commitTransaction);

        /**
         * <p>
         * Command to commit the specified transaction.
         * </p>
         * This is a convenience that creates an instance of the {@link CommitTransactionRequest.Builder} avoiding the
         * need to create one manually via {@link CommitTransactionRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CommitTransactionRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #commitTransaction(CommitTransactionRequest)}.
         * 
         * @param commitTransaction
         *        a consumer that will call methods on {@link CommitTransactionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitTransaction(CommitTransactionRequest)
         */
        default Builder commitTransaction(Consumer<CommitTransactionRequest.Builder> commitTransaction) {
            return commitTransaction(CommitTransactionRequest.builder().applyMutation(commitTransaction).build());
        }

        /**
         * <p>
         * Command to abort the current transaction.
         * </p>
         * 
         * @param abortTransaction
         *        Command to abort the current transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortTransaction(AbortTransactionRequest abortTransaction);

        /**
         * <p>
         * Command to abort the current transaction.
         * </p>
         * This is a convenience that creates an instance of the {@link AbortTransactionRequest.Builder} avoiding the
         * need to create one manually via {@link AbortTransactionRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link AbortTransactionRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #abortTransaction(AbortTransactionRequest)}.
         * 
         * @param abortTransaction
         *        a consumer that will call methods on {@link AbortTransactionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortTransaction(AbortTransactionRequest)
         */
        default Builder abortTransaction(Consumer<AbortTransactionRequest.Builder> abortTransaction) {
            return abortTransaction(AbortTransactionRequest.builder().applyMutation(abortTransaction).build());
        }

        /**
         * <p>
         * Command to execute a statement in the specified transaction.
         * </p>
         * 
         * @param executeStatement
         *        Command to execute a statement in the specified transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executeStatement(ExecuteStatementRequest executeStatement);

        /**
         * <p>
         * Command to execute a statement in the specified transaction.
         * </p>
         * This is a convenience that creates an instance of the {@link ExecuteStatementRequest.Builder} avoiding the
         * need to create one manually via {@link ExecuteStatementRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecuteStatementRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #executeStatement(ExecuteStatementRequest)}.
         * 
         * @param executeStatement
         *        a consumer that will call methods on {@link ExecuteStatementRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executeStatement(ExecuteStatementRequest)
         */
        default Builder executeStatement(Consumer<ExecuteStatementRequest.Builder> executeStatement) {
            return executeStatement(ExecuteStatementRequest.builder().applyMutation(executeStatement).build());
        }

        /**
         * <p>
         * Command to fetch a page.
         * </p>
         * 
         * @param fetchPage
         *        Command to fetch a page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fetchPage(FetchPageRequest fetchPage);

        /**
         * <p>
         * Command to fetch a page.
         * </p>
         * This is a convenience that creates an instance of the {@link FetchPageRequest.Builder} avoiding the need to
         * create one manually via {@link FetchPageRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link FetchPageRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #fetchPage(FetchPageRequest)}.
         * 
         * @param fetchPage
         *        a consumer that will call methods on {@link FetchPageRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fetchPage(FetchPageRequest)
         */
        default Builder fetchPage(Consumer<FetchPageRequest.Builder> fetchPage) {
            return fetchPage(FetchPageRequest.builder().applyMutation(fetchPage).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QldbSessionRequest.BuilderImpl implements Builder {
        private String sessionToken;

        private StartSessionRequest startSession;

        private StartTransactionRequest startTransaction;

        private EndSessionRequest endSession;

        private CommitTransactionRequest commitTransaction;

        private AbortTransactionRequest abortTransaction;

        private ExecuteStatementRequest executeStatement;

        private FetchPageRequest fetchPage;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandRequest model) {
            super(model);
            sessionToken(model.sessionToken);
            startSession(model.startSession);
            startTransaction(model.startTransaction);
            endSession(model.endSession);
            commitTransaction(model.commitTransaction);
            abortTransaction(model.abortTransaction);
            executeStatement(model.executeStatement);
            fetchPage(model.fetchPage);
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        @Transient
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final StartSessionRequest.Builder getStartSession() {
            return startSession != null ? startSession.toBuilder() : null;
        }

        public final void setStartSession(StartSessionRequest.BuilderImpl startSession) {
            this.startSession = startSession != null ? startSession.build() : null;
        }

        @Override
        @Transient
        public final Builder startSession(StartSessionRequest startSession) {
            this.startSession = startSession;
            return this;
        }

        public final StartTransactionRequest.Builder getStartTransaction() {
            return startTransaction != null ? startTransaction.toBuilder() : null;
        }

        public final void setStartTransaction(StartTransactionRequest.BuilderImpl startTransaction) {
            this.startTransaction = startTransaction != null ? startTransaction.build() : null;
        }

        @Override
        @Transient
        public final Builder startTransaction(StartTransactionRequest startTransaction) {
            this.startTransaction = startTransaction;
            return this;
        }

        public final EndSessionRequest.Builder getEndSession() {
            return endSession != null ? endSession.toBuilder() : null;
        }

        public final void setEndSession(EndSessionRequest.BuilderImpl endSession) {
            this.endSession = endSession != null ? endSession.build() : null;
        }

        @Override
        @Transient
        public final Builder endSession(EndSessionRequest endSession) {
            this.endSession = endSession;
            return this;
        }

        public final CommitTransactionRequest.Builder getCommitTransaction() {
            return commitTransaction != null ? commitTransaction.toBuilder() : null;
        }

        public final void setCommitTransaction(CommitTransactionRequest.BuilderImpl commitTransaction) {
            this.commitTransaction = commitTransaction != null ? commitTransaction.build() : null;
        }

        @Override
        @Transient
        public final Builder commitTransaction(CommitTransactionRequest commitTransaction) {
            this.commitTransaction = commitTransaction;
            return this;
        }

        public final AbortTransactionRequest.Builder getAbortTransaction() {
            return abortTransaction != null ? abortTransaction.toBuilder() : null;
        }

        public final void setAbortTransaction(AbortTransactionRequest.BuilderImpl abortTransaction) {
            this.abortTransaction = abortTransaction != null ? abortTransaction.build() : null;
        }

        @Override
        @Transient
        public final Builder abortTransaction(AbortTransactionRequest abortTransaction) {
            this.abortTransaction = abortTransaction;
            return this;
        }

        public final ExecuteStatementRequest.Builder getExecuteStatement() {
            return executeStatement != null ? executeStatement.toBuilder() : null;
        }

        public final void setExecuteStatement(ExecuteStatementRequest.BuilderImpl executeStatement) {
            this.executeStatement = executeStatement != null ? executeStatement.build() : null;
        }

        @Override
        @Transient
        public final Builder executeStatement(ExecuteStatementRequest executeStatement) {
            this.executeStatement = executeStatement;
            return this;
        }

        public final FetchPageRequest.Builder getFetchPage() {
            return fetchPage != null ? fetchPage.toBuilder() : null;
        }

        public final void setFetchPage(FetchPageRequest.BuilderImpl fetchPage) {
            this.fetchPage = fetchPage != null ? fetchPage.build() : null;
        }

        @Override
        @Transient
        public final Builder fetchPage(FetchPageRequest fetchPage) {
            this.fetchPage = fetchPage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCommandRequest build() {
            return new SendCommandRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
