/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the aborted transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbortTransactionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AbortTransactionResult.Builder, AbortTransactionResult> {
    private static final SdkField<TimingInformation> TIMING_INFORMATION_FIELD = SdkField
            .<TimingInformation> builder(MarshallingType.SDK_POJO).memberName("TimingInformation")
            .getter(getter(AbortTransactionResult::timingInformation)).setter(setter(Builder::timingInformation))
            .constructor(TimingInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingInformation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMING_INFORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final TimingInformation timingInformation;

    private AbortTransactionResult(BuilderImpl builder) {
        this.timingInformation = builder.timingInformation;
    }

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @return Contains server-side performance information for the command.
     */
    public final TimingInformation timingInformation() {
        return timingInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timingInformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortTransactionResult)) {
            return false;
        }
        AbortTransactionResult other = (AbortTransactionResult) obj;
        return Objects.equals(timingInformation(), other.timingInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbortTransactionResult").add("TimingInformation", timingInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimingInformation":
            return Optional.ofNullable(clazz.cast(timingInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AbortTransactionResult, T> g) {
        return obj -> g.apply((AbortTransactionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbortTransactionResult> {
        /**
         * <p>
         * Contains server-side performance information for the command.
         * </p>
         * 
         * @param timingInformation
         *        Contains server-side performance information for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timingInformation(TimingInformation timingInformation);

        /**
         * <p>
         * Contains server-side performance information for the command.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimingInformation.Builder} avoiding the
         * need to create one manually via {@link TimingInformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimingInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #timingInformation(TimingInformation)}.
         * 
         * @param timingInformation
         *        a consumer that will call methods on {@link TimingInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timingInformation(TimingInformation)
         */
        default Builder timingInformation(Consumer<TimingInformation.Builder> timingInformation) {
            return timingInformation(TimingInformation.builder().applyMutation(timingInformation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimingInformation timingInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortTransactionResult model) {
            timingInformation(model.timingInformation);
        }

        public final TimingInformation.Builder getTimingInformation() {
            return timingInformation != null ? timingInformation.toBuilder() : null;
        }

        public final void setTimingInformation(TimingInformation.BuilderImpl timingInformation) {
            this.timingInformation = timingInformation != null ? timingInformation.build() : null;
        }

        @Override
        @Transient
        public final Builder timingInformation(TimingInformation timingInformation) {
            this.timingInformation = timingInformation;
            return this;
        }

        @Override
        public AbortTransactionResult build() {
            return new AbortTransactionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
