/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a request to execute a statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecuteStatementRequest.Builder, ExecuteStatementRequest> {
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(ExecuteStatementRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<String> STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statement").getter(getter(ExecuteStatementRequest::statement)).setter(setter(Builder::statement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()).build();

    private static final SdkField<List<ValueHolder>> PARAMETERS_FIELD = SdkField
            .<List<ValueHolder>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(ExecuteStatementRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValueHolder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValueHolder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_ID_FIELD,
            STATEMENT_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transactionId;

    private final String statement;

    private final List<ValueHolder> parameters;

    private ExecuteStatementRequest(BuilderImpl builder) {
        this.transactionId = builder.transactionId;
        this.statement = builder.statement;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * Specifies the transaction ID of the request.
     * </p>
     * 
     * @return Specifies the transaction ID of the request.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * Specifies the statement of the request.
     * </p>
     * 
     * @return Specifies the statement of the request.
     */
    public final String statement() {
        return statement;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the parameters for the parameterized statement in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Specifies the parameters for the parameterized statement in the request.
     */
    public final List<ValueHolder> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(statement());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest) obj;
        return Objects.equals(transactionId(), other.transactionId()) && Objects.equals(statement(), other.statement())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementRequest").add("TransactionId", transactionId()).add("Statement", statement())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "Statement":
            return Optional.ofNullable(clazz.cast(statement()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecuteStatementRequest> {
        /**
         * <p>
         * Specifies the transaction ID of the request.
         * </p>
         * 
         * @param transactionId
         *        Specifies the transaction ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * Specifies the statement of the request.
         * </p>
         * 
         * @param statement
         *        Specifies the statement of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statement(String statement);

        /**
         * <p>
         * Specifies the parameters for the parameterized statement in the request.
         * </p>
         * 
         * @param parameters
         *        Specifies the parameters for the parameterized statement in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ValueHolder> parameters);

        /**
         * <p>
         * Specifies the parameters for the parameterized statement in the request.
         * </p>
         * 
         * @param parameters
         *        Specifies the parameters for the parameterized statement in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ValueHolder... parameters);

        /**
         * <p>
         * Specifies the parameters for the parameterized statement in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValueHolder>.Builder} avoiding the need to
         * create one manually via {@link List<ValueHolder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValueHolder>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<ValueHolder>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<ValueHolder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<ValueHolder>)
         */
        Builder parameters(Consumer<ValueHolder.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String transactionId;

        private String statement;

        private List<ValueHolder> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            transactionId(model.transactionId);
            statement(model.statement);
            parameters(model.parameters);
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        @Transient
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getStatement() {
            return statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        @Transient
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final List<ValueHolder.Builder> getParameters() {
            List<ValueHolder.Builder> result = StatementParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ValueHolder.BuilderImpl> parameters) {
            this.parameters = StatementParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Collection<ValueHolder> parameters) {
            this.parameters = StatementParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(ValueHolder... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(Consumer<ValueHolder.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> ValueHolder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
