/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains server-side performance information for a command. Amazon QLDB captures timing information between the times
 * when it receives the request and when it sends the corresponding response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimingInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<TimingInformation.Builder, TimingInformation> {
    private static final SdkField<Long> PROCESSING_TIME_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ProcessingTimeMilliseconds")
            .getter(getter(TimingInformation::processingTimeMilliseconds))
            .setter(setter(Builder::processingTimeMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingTimeMilliseconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROCESSING_TIME_MILLISECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long processingTimeMilliseconds;

    private TimingInformation(BuilderImpl builder) {
        this.processingTimeMilliseconds = builder.processingTimeMilliseconds;
    }

    /**
     * <p>
     * The amount of time that QLDB spent on processing the command, measured in milliseconds.
     * </p>
     * 
     * @return The amount of time that QLDB spent on processing the command, measured in milliseconds.
     */
    public final Long processingTimeMilliseconds() {
        return processingTimeMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(processingTimeMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimingInformation)) {
            return false;
        }
        TimingInformation other = (TimingInformation) obj;
        return Objects.equals(processingTimeMilliseconds(), other.processingTimeMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimingInformation").add("ProcessingTimeMilliseconds", processingTimeMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessingTimeMilliseconds":
            return Optional.ofNullable(clazz.cast(processingTimeMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimingInformation, T> g) {
        return obj -> g.apply((TimingInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimingInformation> {
        /**
         * <p>
         * The amount of time that QLDB spent on processing the command, measured in milliseconds.
         * </p>
         * 
         * @param processingTimeMilliseconds
         *        The amount of time that QLDB spent on processing the command, measured in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingTimeMilliseconds(Long processingTimeMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private Long processingTimeMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TimingInformation model) {
            processingTimeMilliseconds(model.processingTimeMilliseconds);
        }

        public final Long getProcessingTimeMilliseconds() {
            return processingTimeMilliseconds;
        }

        public final void setProcessingTimeMilliseconds(Long processingTimeMilliseconds) {
            this.processingTimeMilliseconds = processingTimeMilliseconds;
        }

        @Override
        @Transient
        public final Builder processingTimeMilliseconds(Long processingTimeMilliseconds) {
            this.processingTimeMilliseconds = processingTimeMilliseconds;
            return this;
        }

        @Override
        public TimingInformation build() {
            return new TimingInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
