/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.qldbsession.DefaultQldbSessionClientBuilder;
import software.amazon.awssdk.services.qldbsession.QldbSessionClientBuilder;
import software.amazon.awssdk.services.qldbsession.QldbSessionServiceClientConfiguration;
import software.amazon.awssdk.services.qldbsession.model.BadRequestException;
import software.amazon.awssdk.services.qldbsession.model.CapacityExceededException;
import software.amazon.awssdk.services.qldbsession.model.InvalidSessionException;
import software.amazon.awssdk.services.qldbsession.model.LimitExceededException;
import software.amazon.awssdk.services.qldbsession.model.OccConflictException;
import software.amazon.awssdk.services.qldbsession.model.QldbSessionException;
import software.amazon.awssdk.services.qldbsession.model.RateExceededException;
import software.amazon.awssdk.services.qldbsession.model.SendCommandRequest;
import software.amazon.awssdk.services.qldbsession.model.SendCommandResponse;

@SdkPublicApi
@ThreadSafe
public interface QldbSessionClient
extends AwsClient {
    public static final String SERVICE_NAME = "qldb";
    public static final String SERVICE_METADATA_ID = "session.qldb";

    default public SendCommandResponse sendCommand(SendCommandRequest sendCommandRequest) throws BadRequestException, InvalidSessionException, OccConflictException, RateExceededException, LimitExceededException, CapacityExceededException, AwsServiceException, SdkClientException, QldbSessionException {
        throw new UnsupportedOperationException();
    }

    default public SendCommandResponse sendCommand(Consumer<SendCommandRequest.Builder> sendCommandRequest) throws BadRequestException, InvalidSessionException, OccConflictException, RateExceededException, LimitExceededException, CapacityExceededException, AwsServiceException, SdkClientException, QldbSessionException {
        return this.sendCommand((SendCommandRequest)((Object)((SendCommandRequest.Builder)SendCommandRequest.builder().applyMutation(sendCommandRequest)).build()));
    }

    public static QldbSessionClient create() {
        return (QldbSessionClient)QldbSessionClient.builder().build();
    }

    public static QldbSessionClientBuilder builder() {
        return new DefaultQldbSessionClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    public QldbSessionServiceClientConfiguration serviceClientConfiguration();
}

