/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the page that was fetched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FetchPageResult implements SdkPojo, Serializable, ToCopyableBuilder<FetchPageResult.Builder, FetchPageResult> {
    private static final SdkField<Page> PAGE_FIELD = SdkField.<Page> builder(MarshallingType.SDK_POJO).memberName("Page")
            .getter(getter(FetchPageResult::page)).setter(setter(Builder::page)).constructor(Page::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()).build();

    private static final SdkField<TimingInformation> TIMING_INFORMATION_FIELD = SdkField
            .<TimingInformation> builder(MarshallingType.SDK_POJO).memberName("TimingInformation")
            .getter(getter(FetchPageResult::timingInformation)).setter(setter(Builder::timingInformation))
            .constructor(TimingInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingInformation").build()).build();

    private static final SdkField<IOUsage> CONSUMED_I_OS_FIELD = SdkField.<IOUsage> builder(MarshallingType.SDK_POJO)
            .memberName("ConsumedIOs").getter(getter(FetchPageResult::consumedIOs)).setter(setter(Builder::consumedIOs))
            .constructor(IOUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedIOs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_FIELD,
            TIMING_INFORMATION_FIELD, CONSUMED_I_OS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Page page;

    private final TimingInformation timingInformation;

    private final IOUsage consumedIOs;

    private FetchPageResult(BuilderImpl builder) {
        this.page = builder.page;
        this.timingInformation = builder.timingInformation;
        this.consumedIOs = builder.consumedIOs;
    }

    /**
     * <p>
     * Contains details of the fetched page.
     * </p>
     * 
     * @return Contains details of the fetched page.
     */
    public final Page page() {
        return page;
    }

    /**
     * <p>
     * Contains server-side performance information for the command.
     * </p>
     * 
     * @return Contains server-side performance information for the command.
     */
    public final TimingInformation timingInformation() {
        return timingInformation;
    }

    /**
     * <p>
     * Contains metrics about the number of I/O requests that were consumed.
     * </p>
     * 
     * @return Contains metrics about the number of I/O requests that were consumed.
     */
    public final IOUsage consumedIOs() {
        return consumedIOs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(page());
        hashCode = 31 * hashCode + Objects.hashCode(timingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(consumedIOs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FetchPageResult)) {
            return false;
        }
        FetchPageResult other = (FetchPageResult) obj;
        return Objects.equals(page(), other.page()) && Objects.equals(timingInformation(), other.timingInformation())
                && Objects.equals(consumedIOs(), other.consumedIOs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FetchPageResult").add("Page", page()).add("TimingInformation", timingInformation())
                .add("ConsumedIOs", consumedIOs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Page":
            return Optional.ofNullable(clazz.cast(page()));
        case "TimingInformation":
            return Optional.ofNullable(clazz.cast(timingInformation()));
        case "ConsumedIOs":
            return Optional.ofNullable(clazz.cast(consumedIOs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FetchPageResult, T> g) {
        return obj -> g.apply((FetchPageResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FetchPageResult> {
        /**
         * <p>
         * Contains details of the fetched page.
         * </p>
         * 
         * @param page
         *        Contains details of the fetched page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder page(Page page);

        /**
         * <p>
         * Contains details of the fetched page.
         * </p>
         * This is a convenience method that creates an instance of the {@link Page.Builder} avoiding the need to create
         * one manually via {@link Page#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Page.Builder#build()} is called immediately and its result is
         * passed to {@link #page(Page)}.
         * 
         * @param page
         *        a consumer that will call methods on {@link Page.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #page(Page)
         */
        default Builder page(Consumer<Page.Builder> page) {
            return page(Page.builder().applyMutation(page).build());
        }

        /**
         * <p>
         * Contains server-side performance information for the command.
         * </p>
         * 
         * @param timingInformation
         *        Contains server-side performance information for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timingInformation(TimingInformation timingInformation);

        /**
         * <p>
         * Contains server-side performance information for the command.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimingInformation.Builder} avoiding the
         * need to create one manually via {@link TimingInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimingInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #timingInformation(TimingInformation)}.
         * 
         * @param timingInformation
         *        a consumer that will call methods on {@link TimingInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timingInformation(TimingInformation)
         */
        default Builder timingInformation(Consumer<TimingInformation.Builder> timingInformation) {
            return timingInformation(TimingInformation.builder().applyMutation(timingInformation).build());
        }

        /**
         * <p>
         * Contains metrics about the number of I/O requests that were consumed.
         * </p>
         * 
         * @param consumedIOs
         *        Contains metrics about the number of I/O requests that were consumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedIOs(IOUsage consumedIOs);

        /**
         * <p>
         * Contains metrics about the number of I/O requests that were consumed.
         * </p>
         * This is a convenience method that creates an instance of the {@link IOUsage.Builder} avoiding the need to
         * create one manually via {@link IOUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IOUsage.Builder#build()} is called immediately and its result is
         * passed to {@link #consumedIOs(IOUsage)}.
         * 
         * @param consumedIOs
         *        a consumer that will call methods on {@link IOUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedIOs(IOUsage)
         */
        default Builder consumedIOs(Consumer<IOUsage.Builder> consumedIOs) {
            return consumedIOs(IOUsage.builder().applyMutation(consumedIOs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Page page;

        private TimingInformation timingInformation;

        private IOUsage consumedIOs;

        private BuilderImpl() {
        }

        private BuilderImpl(FetchPageResult model) {
            page(model.page);
            timingInformation(model.timingInformation);
            consumedIOs(model.consumedIOs);
        }

        public final Page.Builder getPage() {
            return page != null ? page.toBuilder() : null;
        }

        public final void setPage(Page.BuilderImpl page) {
            this.page = page != null ? page.build() : null;
        }

        @Override
        public final Builder page(Page page) {
            this.page = page;
            return this;
        }

        public final TimingInformation.Builder getTimingInformation() {
            return timingInformation != null ? timingInformation.toBuilder() : null;
        }

        public final void setTimingInformation(TimingInformation.BuilderImpl timingInformation) {
            this.timingInformation = timingInformation != null ? timingInformation.build() : null;
        }

        @Override
        public final Builder timingInformation(TimingInformation timingInformation) {
            this.timingInformation = timingInformation;
            return this;
        }

        public final IOUsage.Builder getConsumedIOs() {
            return consumedIOs != null ? consumedIOs.toBuilder() : null;
        }

        public final void setConsumedIOs(IOUsage.BuilderImpl consumedIOs) {
            this.consumedIOs = consumedIOs != null ? consumedIOs.build() : null;
        }

        @Override
        public final Builder consumedIOs(IOUsage consumedIOs) {
            this.consumedIOs = consumedIOs;
            return this;
        }

        @Override
        public FetchPageResult build() {
            return new FetchPageResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
