/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendCommandResponse extends QldbSessionResponse implements
        ToCopyableBuilder<SendCommandResponse.Builder, SendCommandResponse> {
    private static final SdkField<StartSessionResult> START_SESSION_FIELD = SdkField
            .<StartSessionResult> builder(MarshallingType.SDK_POJO).memberName("StartSession")
            .getter(getter(SendCommandResponse::startSession)).setter(setter(Builder::startSession))
            .constructor(StartSessionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSession").build()).build();

    private static final SdkField<StartTransactionResult> START_TRANSACTION_FIELD = SdkField
            .<StartTransactionResult> builder(MarshallingType.SDK_POJO).memberName("StartTransaction")
            .getter(getter(SendCommandResponse::startTransaction)).setter(setter(Builder::startTransaction))
            .constructor(StartTransactionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTransaction").build()).build();

    private static final SdkField<EndSessionResult> END_SESSION_FIELD = SdkField
            .<EndSessionResult> builder(MarshallingType.SDK_POJO).memberName("EndSession")
            .getter(getter(SendCommandResponse::endSession)).setter(setter(Builder::endSession))
            .constructor(EndSessionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndSession").build()).build();

    private static final SdkField<CommitTransactionResult> COMMIT_TRANSACTION_FIELD = SdkField
            .<CommitTransactionResult> builder(MarshallingType.SDK_POJO).memberName("CommitTransaction")
            .getter(getter(SendCommandResponse::commitTransaction)).setter(setter(Builder::commitTransaction))
            .constructor(CommitTransactionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitTransaction").build()).build();

    private static final SdkField<AbortTransactionResult> ABORT_TRANSACTION_FIELD = SdkField
            .<AbortTransactionResult> builder(MarshallingType.SDK_POJO).memberName("AbortTransaction")
            .getter(getter(SendCommandResponse::abortTransaction)).setter(setter(Builder::abortTransaction))
            .constructor(AbortTransactionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortTransaction").build()).build();

    private static final SdkField<ExecuteStatementResult> EXECUTE_STATEMENT_FIELD = SdkField
            .<ExecuteStatementResult> builder(MarshallingType.SDK_POJO).memberName("ExecuteStatement")
            .getter(getter(SendCommandResponse::executeStatement)).setter(setter(Builder::executeStatement))
            .constructor(ExecuteStatementResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteStatement").build()).build();

    private static final SdkField<FetchPageResult> FETCH_PAGE_FIELD = SdkField
            .<FetchPageResult> builder(MarshallingType.SDK_POJO).memberName("FetchPage")
            .getter(getter(SendCommandResponse::fetchPage)).setter(setter(Builder::fetchPage))
            .constructor(FetchPageResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FetchPage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_SESSION_FIELD,
            START_TRANSACTION_FIELD, END_SESSION_FIELD, COMMIT_TRANSACTION_FIELD, ABORT_TRANSACTION_FIELD,
            EXECUTE_STATEMENT_FIELD, FETCH_PAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StartSessionResult startSession;

    private final StartTransactionResult startTransaction;

    private final EndSessionResult endSession;

    private final CommitTransactionResult commitTransaction;

    private final AbortTransactionResult abortTransaction;

    private final ExecuteStatementResult executeStatement;

    private final FetchPageResult fetchPage;

    private SendCommandResponse(BuilderImpl builder) {
        super(builder);
        this.startSession = builder.startSession;
        this.startTransaction = builder.startTransaction;
        this.endSession = builder.endSession;
        this.commitTransaction = builder.commitTransaction;
        this.abortTransaction = builder.abortTransaction;
        this.executeStatement = builder.executeStatement;
        this.fetchPage = builder.fetchPage;
    }

    /**
     * <p>
     * Contains the details of the started session that includes a session token. This <code>SessionToken</code> is
     * required for every subsequent command that is issued during the current session.
     * </p>
     * 
     * @return Contains the details of the started session that includes a session token. This <code>SessionToken</code>
     *         is required for every subsequent command that is issued during the current session.
     */
    public final StartSessionResult startSession() {
        return startSession;
    }

    /**
     * <p>
     * Contains the details of the started transaction.
     * </p>
     * 
     * @return Contains the details of the started transaction.
     */
    public final StartTransactionResult startTransaction() {
        return startTransaction;
    }

    /**
     * <p>
     * Contains the details of the ended session.
     * </p>
     * 
     * @return Contains the details of the ended session.
     */
    public final EndSessionResult endSession() {
        return endSession;
    }

    /**
     * <p>
     * Contains the details of the committed transaction.
     * </p>
     * 
     * @return Contains the details of the committed transaction.
     */
    public final CommitTransactionResult commitTransaction() {
        return commitTransaction;
    }

    /**
     * <p>
     * Contains the details of the aborted transaction.
     * </p>
     * 
     * @return Contains the details of the aborted transaction.
     */
    public final AbortTransactionResult abortTransaction() {
        return abortTransaction;
    }

    /**
     * <p>
     * Contains the details of the executed statement.
     * </p>
     * 
     * @return Contains the details of the executed statement.
     */
    public final ExecuteStatementResult executeStatement() {
        return executeStatement;
    }

    /**
     * <p>
     * Contains the details of the fetched page.
     * </p>
     * 
     * @return Contains the details of the fetched page.
     */
    public final FetchPageResult fetchPage() {
        return fetchPage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startSession());
        hashCode = 31 * hashCode + Objects.hashCode(startTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(endSession());
        hashCode = 31 * hashCode + Objects.hashCode(commitTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(abortTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(executeStatement());
        hashCode = 31 * hashCode + Objects.hashCode(fetchPage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandResponse)) {
            return false;
        }
        SendCommandResponse other = (SendCommandResponse) obj;
        return Objects.equals(startSession(), other.startSession())
                && Objects.equals(startTransaction(), other.startTransaction())
                && Objects.equals(endSession(), other.endSession())
                && Objects.equals(commitTransaction(), other.commitTransaction())
                && Objects.equals(abortTransaction(), other.abortTransaction())
                && Objects.equals(executeStatement(), other.executeStatement()) && Objects.equals(fetchPage(), other.fetchPage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendCommandResponse").add("StartSession", startSession())
                .add("StartTransaction", startTransaction()).add("EndSession", endSession())
                .add("CommitTransaction", commitTransaction()).add("AbortTransaction", abortTransaction())
                .add("ExecuteStatement", executeStatement()).add("FetchPage", fetchPage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartSession":
            return Optional.ofNullable(clazz.cast(startSession()));
        case "StartTransaction":
            return Optional.ofNullable(clazz.cast(startTransaction()));
        case "EndSession":
            return Optional.ofNullable(clazz.cast(endSession()));
        case "CommitTransaction":
            return Optional.ofNullable(clazz.cast(commitTransaction()));
        case "AbortTransaction":
            return Optional.ofNullable(clazz.cast(abortTransaction()));
        case "ExecuteStatement":
            return Optional.ofNullable(clazz.cast(executeStatement()));
        case "FetchPage":
            return Optional.ofNullable(clazz.cast(fetchPage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartSession", START_SESSION_FIELD);
        map.put("StartTransaction", START_TRANSACTION_FIELD);
        map.put("EndSession", END_SESSION_FIELD);
        map.put("CommitTransaction", COMMIT_TRANSACTION_FIELD);
        map.put("AbortTransaction", ABORT_TRANSACTION_FIELD);
        map.put("ExecuteStatement", EXECUTE_STATEMENT_FIELD);
        map.put("FetchPage", FETCH_PAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendCommandResponse, T> g) {
        return obj -> g.apply((SendCommandResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbSessionResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendCommandResponse> {
        /**
         * <p>
         * Contains the details of the started session that includes a session token. This <code>SessionToken</code> is
         * required for every subsequent command that is issued during the current session.
         * </p>
         * 
         * @param startSession
         *        Contains the details of the started session that includes a session token. This
         *        <code>SessionToken</code> is required for every subsequent command that is issued during the current
         *        session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSession(StartSessionResult startSession);

        /**
         * <p>
         * Contains the details of the started session that includes a session token. This <code>SessionToken</code> is
         * required for every subsequent command that is issued during the current session.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartSessionResult.Builder} avoiding the
         * need to create one manually via {@link StartSessionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartSessionResult.Builder#build()} is called immediately and its
         * result is passed to {@link #startSession(StartSessionResult)}.
         * 
         * @param startSession
         *        a consumer that will call methods on {@link StartSessionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startSession(StartSessionResult)
         */
        default Builder startSession(Consumer<StartSessionResult.Builder> startSession) {
            return startSession(StartSessionResult.builder().applyMutation(startSession).build());
        }

        /**
         * <p>
         * Contains the details of the started transaction.
         * </p>
         * 
         * @param startTransaction
         *        Contains the details of the started transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTransaction(StartTransactionResult startTransaction);

        /**
         * <p>
         * Contains the details of the started transaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartTransactionResult.Builder} avoiding
         * the need to create one manually via {@link StartTransactionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartTransactionResult.Builder#build()} is called immediately and
         * its result is passed to {@link #startTransaction(StartTransactionResult)}.
         * 
         * @param startTransaction
         *        a consumer that will call methods on {@link StartTransactionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTransaction(StartTransactionResult)
         */
        default Builder startTransaction(Consumer<StartTransactionResult.Builder> startTransaction) {
            return startTransaction(StartTransactionResult.builder().applyMutation(startTransaction).build());
        }

        /**
         * <p>
         * Contains the details of the ended session.
         * </p>
         * 
         * @param endSession
         *        Contains the details of the ended session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endSession(EndSessionResult endSession);

        /**
         * <p>
         * Contains the details of the ended session.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndSessionResult.Builder} avoiding the
         * need to create one manually via {@link EndSessionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndSessionResult.Builder#build()} is called immediately and its
         * result is passed to {@link #endSession(EndSessionResult)}.
         * 
         * @param endSession
         *        a consumer that will call methods on {@link EndSessionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endSession(EndSessionResult)
         */
        default Builder endSession(Consumer<EndSessionResult.Builder> endSession) {
            return endSession(EndSessionResult.builder().applyMutation(endSession).build());
        }

        /**
         * <p>
         * Contains the details of the committed transaction.
         * </p>
         * 
         * @param commitTransaction
         *        Contains the details of the committed transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitTransaction(CommitTransactionResult commitTransaction);

        /**
         * <p>
         * Contains the details of the committed transaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommitTransactionResult.Builder} avoiding
         * the need to create one manually via {@link CommitTransactionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommitTransactionResult.Builder#build()} is called immediately
         * and its result is passed to {@link #commitTransaction(CommitTransactionResult)}.
         * 
         * @param commitTransaction
         *        a consumer that will call methods on {@link CommitTransactionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitTransaction(CommitTransactionResult)
         */
        default Builder commitTransaction(Consumer<CommitTransactionResult.Builder> commitTransaction) {
            return commitTransaction(CommitTransactionResult.builder().applyMutation(commitTransaction).build());
        }

        /**
         * <p>
         * Contains the details of the aborted transaction.
         * </p>
         * 
         * @param abortTransaction
         *        Contains the details of the aborted transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortTransaction(AbortTransactionResult abortTransaction);

        /**
         * <p>
         * Contains the details of the aborted transaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link AbortTransactionResult.Builder} avoiding
         * the need to create one manually via {@link AbortTransactionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AbortTransactionResult.Builder#build()} is called immediately and
         * its result is passed to {@link #abortTransaction(AbortTransactionResult)}.
         * 
         * @param abortTransaction
         *        a consumer that will call methods on {@link AbortTransactionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortTransaction(AbortTransactionResult)
         */
        default Builder abortTransaction(Consumer<AbortTransactionResult.Builder> abortTransaction) {
            return abortTransaction(AbortTransactionResult.builder().applyMutation(abortTransaction).build());
        }

        /**
         * <p>
         * Contains the details of the executed statement.
         * </p>
         * 
         * @param executeStatement
         *        Contains the details of the executed statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executeStatement(ExecuteStatementResult executeStatement);

        /**
         * <p>
         * Contains the details of the executed statement.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecuteStatementResult.Builder} avoiding
         * the need to create one manually via {@link ExecuteStatementResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecuteStatementResult.Builder#build()} is called immediately and
         * its result is passed to {@link #executeStatement(ExecuteStatementResult)}.
         * 
         * @param executeStatement
         *        a consumer that will call methods on {@link ExecuteStatementResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executeStatement(ExecuteStatementResult)
         */
        default Builder executeStatement(Consumer<ExecuteStatementResult.Builder> executeStatement) {
            return executeStatement(ExecuteStatementResult.builder().applyMutation(executeStatement).build());
        }

        /**
         * <p>
         * Contains the details of the fetched page.
         * </p>
         * 
         * @param fetchPage
         *        Contains the details of the fetched page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fetchPage(FetchPageResult fetchPage);

        /**
         * <p>
         * Contains the details of the fetched page.
         * </p>
         * This is a convenience method that creates an instance of the {@link FetchPageResult.Builder} avoiding the
         * need to create one manually via {@link FetchPageResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FetchPageResult.Builder#build()} is called immediately and its
         * result is passed to {@link #fetchPage(FetchPageResult)}.
         * 
         * @param fetchPage
         *        a consumer that will call methods on {@link FetchPageResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fetchPage(FetchPageResult)
         */
        default Builder fetchPage(Consumer<FetchPageResult.Builder> fetchPage) {
            return fetchPage(FetchPageResult.builder().applyMutation(fetchPage).build());
        }
    }

    static final class BuilderImpl extends QldbSessionResponse.BuilderImpl implements Builder {
        private StartSessionResult startSession;

        private StartTransactionResult startTransaction;

        private EndSessionResult endSession;

        private CommitTransactionResult commitTransaction;

        private AbortTransactionResult abortTransaction;

        private ExecuteStatementResult executeStatement;

        private FetchPageResult fetchPage;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandResponse model) {
            super(model);
            startSession(model.startSession);
            startTransaction(model.startTransaction);
            endSession(model.endSession);
            commitTransaction(model.commitTransaction);
            abortTransaction(model.abortTransaction);
            executeStatement(model.executeStatement);
            fetchPage(model.fetchPage);
        }

        public final StartSessionResult.Builder getStartSession() {
            return startSession != null ? startSession.toBuilder() : null;
        }

        public final void setStartSession(StartSessionResult.BuilderImpl startSession) {
            this.startSession = startSession != null ? startSession.build() : null;
        }

        @Override
        public final Builder startSession(StartSessionResult startSession) {
            this.startSession = startSession;
            return this;
        }

        public final StartTransactionResult.Builder getStartTransaction() {
            return startTransaction != null ? startTransaction.toBuilder() : null;
        }

        public final void setStartTransaction(StartTransactionResult.BuilderImpl startTransaction) {
            this.startTransaction = startTransaction != null ? startTransaction.build() : null;
        }

        @Override
        public final Builder startTransaction(StartTransactionResult startTransaction) {
            this.startTransaction = startTransaction;
            return this;
        }

        public final EndSessionResult.Builder getEndSession() {
            return endSession != null ? endSession.toBuilder() : null;
        }

        public final void setEndSession(EndSessionResult.BuilderImpl endSession) {
            this.endSession = endSession != null ? endSession.build() : null;
        }

        @Override
        public final Builder endSession(EndSessionResult endSession) {
            this.endSession = endSession;
            return this;
        }

        public final CommitTransactionResult.Builder getCommitTransaction() {
            return commitTransaction != null ? commitTransaction.toBuilder() : null;
        }

        public final void setCommitTransaction(CommitTransactionResult.BuilderImpl commitTransaction) {
            this.commitTransaction = commitTransaction != null ? commitTransaction.build() : null;
        }

        @Override
        public final Builder commitTransaction(CommitTransactionResult commitTransaction) {
            this.commitTransaction = commitTransaction;
            return this;
        }

        public final AbortTransactionResult.Builder getAbortTransaction() {
            return abortTransaction != null ? abortTransaction.toBuilder() : null;
        }

        public final void setAbortTransaction(AbortTransactionResult.BuilderImpl abortTransaction) {
            this.abortTransaction = abortTransaction != null ? abortTransaction.build() : null;
        }

        @Override
        public final Builder abortTransaction(AbortTransactionResult abortTransaction) {
            this.abortTransaction = abortTransaction;
            return this;
        }

        public final ExecuteStatementResult.Builder getExecuteStatement() {
            return executeStatement != null ? executeStatement.toBuilder() : null;
        }

        public final void setExecuteStatement(ExecuteStatementResult.BuilderImpl executeStatement) {
            this.executeStatement = executeStatement != null ? executeStatement.build() : null;
        }

        @Override
        public final Builder executeStatement(ExecuteStatementResult executeStatement) {
            this.executeStatement = executeStatement;
            return this;
        }

        public final FetchPageResult.Builder getFetchPage() {
            return fetchPage != null ? fetchPage.toBuilder() : null;
        }

        public final void setFetchPage(FetchPageResult.BuilderImpl fetchPage) {
            this.fetchPage = fetchPage != null ? fetchPage.build() : null;
        }

        @Override
        public final Builder fetchPage(FetchPageResult fetchPage) {
            this.fetchPage = fetchPage;
            return this;
        }

        @Override
        public SendCommandResponse build() {
            return new SendCommandResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
