/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldbsession.model.IOUsage;
import software.amazon.awssdk.services.qldbsession.model.Page;
import software.amazon.awssdk.services.qldbsession.model.TimingInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FetchPageResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FetchPageResult> {
    private static final SdkField<Page> PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Page").getter(FetchPageResult.getter(FetchPageResult::page)).setter(FetchPageResult.setter(Builder::page)).constructor(Page::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()}).build();
    private static final SdkField<TimingInformation> TIMING_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimingInformation").getter(FetchPageResult.getter(FetchPageResult::timingInformation)).setter(FetchPageResult.setter(Builder::timingInformation)).constructor(TimingInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimingInformation").build()}).build();
    private static final SdkField<IOUsage> CONSUMED_I_OS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumedIOs").getter(FetchPageResult.getter(FetchPageResult::consumedIOs)).setter(FetchPageResult.setter(Builder::consumedIOs)).constructor(IOUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedIOs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_FIELD, TIMING_INFORMATION_FIELD, CONSUMED_I_OS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FetchPageResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Page page;
    private final TimingInformation timingInformation;
    private final IOUsage consumedIOs;

    private FetchPageResult(BuilderImpl builder) {
        this.page = builder.page;
        this.timingInformation = builder.timingInformation;
        this.consumedIOs = builder.consumedIOs;
    }

    public final Page page() {
        return this.page;
    }

    public final TimingInformation timingInformation() {
        return this.timingInformation;
    }

    public final IOUsage consumedIOs() {
        return this.consumedIOs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.page());
        hashCode = 31 * hashCode + Objects.hashCode(this.timingInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedIOs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FetchPageResult)) {
            return false;
        }
        FetchPageResult other = (FetchPageResult)obj;
        return Objects.equals(this.page(), other.page()) && Objects.equals(this.timingInformation(), other.timingInformation()) && Objects.equals(this.consumedIOs(), other.consumedIOs());
    }

    public final String toString() {
        return ToString.builder((String)"FetchPageResult").add("Page", (Object)this.page()).add("TimingInformation", (Object)this.timingInformation()).add("ConsumedIOs", (Object)this.consumedIOs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Page": {
                return Optional.ofNullable(clazz.cast(this.page()));
            }
            case "TimingInformation": {
                return Optional.ofNullable(clazz.cast(this.timingInformation()));
            }
            case "ConsumedIOs": {
                return Optional.ofNullable(clazz.cast(this.consumedIOs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Page", PAGE_FIELD);
        map.put("TimingInformation", TIMING_INFORMATION_FIELD);
        map.put("ConsumedIOs", CONSUMED_I_OS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FetchPageResult, T> g) {
        return obj -> g.apply((FetchPageResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Page page;
        private TimingInformation timingInformation;
        private IOUsage consumedIOs;

        private BuilderImpl() {
        }

        private BuilderImpl(FetchPageResult model) {
            this.page(model.page);
            this.timingInformation(model.timingInformation);
            this.consumedIOs(model.consumedIOs);
        }

        public final Page.Builder getPage() {
            return this.page != null ? this.page.toBuilder() : null;
        }

        public final void setPage(Page.BuilderImpl page) {
            this.page = page != null ? page.build() : null;
        }

        @Override
        public final Builder page(Page page) {
            this.page = page;
            return this;
        }

        public final TimingInformation.Builder getTimingInformation() {
            return this.timingInformation != null ? this.timingInformation.toBuilder() : null;
        }

        public final void setTimingInformation(TimingInformation.BuilderImpl timingInformation) {
            this.timingInformation = timingInformation != null ? timingInformation.build() : null;
        }

        @Override
        public final Builder timingInformation(TimingInformation timingInformation) {
            this.timingInformation = timingInformation;
            return this;
        }

        public final IOUsage.Builder getConsumedIOs() {
            return this.consumedIOs != null ? this.consumedIOs.toBuilder() : null;
        }

        public final void setConsumedIOs(IOUsage.BuilderImpl consumedIOs) {
            this.consumedIOs = consumedIOs != null ? consumedIOs.build() : null;
        }

        @Override
        public final Builder consumedIOs(IOUsage consumedIOs) {
            this.consumedIOs = consumedIOs;
            return this;
        }

        public FetchPageResult build() {
            return new FetchPageResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FetchPageResult> {
        public Builder page(Page var1);

        default public Builder page(Consumer<Page.Builder> page) {
            return this.page((Page)((Page.Builder)Page.builder().applyMutation(page)).build());
        }

        public Builder timingInformation(TimingInformation var1);

        default public Builder timingInformation(Consumer<TimingInformation.Builder> timingInformation) {
            return this.timingInformation((TimingInformation)((TimingInformation.Builder)TimingInformation.builder().applyMutation(timingInformation)).build());
        }

        public Builder consumedIOs(IOUsage var1);

        default public Builder consumedIOs(Consumer<IOUsage.Builder> consumedIOs) {
            return this.consumedIOs((IOUsage)((IOUsage.Builder)IOUsage.builder().applyMutation(consumedIOs)).build());
        }
    }
}

