/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldbsession.model.AbortTransactionResult;
import software.amazon.awssdk.services.qldbsession.model.CommitTransactionResult;
import software.amazon.awssdk.services.qldbsession.model.EndSessionResult;
import software.amazon.awssdk.services.qldbsession.model.ExecuteStatementResult;
import software.amazon.awssdk.services.qldbsession.model.FetchPageResult;
import software.amazon.awssdk.services.qldbsession.model.QldbSessionResponse;
import software.amazon.awssdk.services.qldbsession.model.StartSessionResult;
import software.amazon.awssdk.services.qldbsession.model.StartTransactionResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendCommandResponse
extends QldbSessionResponse
implements ToCopyableBuilder<Builder, SendCommandResponse> {
    private static final SdkField<StartSessionResult> START_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartSession").getter(SendCommandResponse.getter(SendCommandResponse::startSession)).setter(SendCommandResponse.setter(Builder::startSession)).constructor(StartSessionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSession").build()}).build();
    private static final SdkField<StartTransactionResult> START_TRANSACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartTransaction").getter(SendCommandResponse.getter(SendCommandResponse::startTransaction)).setter(SendCommandResponse.setter(Builder::startTransaction)).constructor(StartTransactionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTransaction").build()}).build();
    private static final SdkField<EndSessionResult> END_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndSession").getter(SendCommandResponse.getter(SendCommandResponse::endSession)).setter(SendCommandResponse.setter(Builder::endSession)).constructor(EndSessionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndSession").build()}).build();
    private static final SdkField<CommitTransactionResult> COMMIT_TRANSACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CommitTransaction").getter(SendCommandResponse.getter(SendCommandResponse::commitTransaction)).setter(SendCommandResponse.setter(Builder::commitTransaction)).constructor(CommitTransactionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitTransaction").build()}).build();
    private static final SdkField<AbortTransactionResult> ABORT_TRANSACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbortTransaction").getter(SendCommandResponse.getter(SendCommandResponse::abortTransaction)).setter(SendCommandResponse.setter(Builder::abortTransaction)).constructor(AbortTransactionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortTransaction").build()}).build();
    private static final SdkField<ExecuteStatementResult> EXECUTE_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecuteStatement").getter(SendCommandResponse.getter(SendCommandResponse::executeStatement)).setter(SendCommandResponse.setter(Builder::executeStatement)).constructor(ExecuteStatementResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteStatement").build()}).build();
    private static final SdkField<FetchPageResult> FETCH_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FetchPage").getter(SendCommandResponse.getter(SendCommandResponse::fetchPage)).setter(SendCommandResponse.setter(Builder::fetchPage)).constructor(FetchPageResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FetchPage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_SESSION_FIELD, START_TRANSACTION_FIELD, END_SESSION_FIELD, COMMIT_TRANSACTION_FIELD, ABORT_TRANSACTION_FIELD, EXECUTE_STATEMENT_FIELD, FETCH_PAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendCommandResponse.memberNameToFieldInitializer();
    private final StartSessionResult startSession;
    private final StartTransactionResult startTransaction;
    private final EndSessionResult endSession;
    private final CommitTransactionResult commitTransaction;
    private final AbortTransactionResult abortTransaction;
    private final ExecuteStatementResult executeStatement;
    private final FetchPageResult fetchPage;

    private SendCommandResponse(BuilderImpl builder) {
        super(builder);
        this.startSession = builder.startSession;
        this.startTransaction = builder.startTransaction;
        this.endSession = builder.endSession;
        this.commitTransaction = builder.commitTransaction;
        this.abortTransaction = builder.abortTransaction;
        this.executeStatement = builder.executeStatement;
        this.fetchPage = builder.fetchPage;
    }

    public final StartSessionResult startSession() {
        return this.startSession;
    }

    public final StartTransactionResult startTransaction() {
        return this.startTransaction;
    }

    public final EndSessionResult endSession() {
        return this.endSession;
    }

    public final CommitTransactionResult commitTransaction() {
        return this.commitTransaction;
    }

    public final AbortTransactionResult abortTransaction() {
        return this.abortTransaction;
    }

    public final ExecuteStatementResult executeStatement() {
        return this.executeStatement;
    }

    public final FetchPageResult fetchPage() {
        return this.fetchPage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.endSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortTransaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.executeStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.fetchPage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandResponse)) {
            return false;
        }
        SendCommandResponse other = (SendCommandResponse)((Object)obj);
        return Objects.equals(this.startSession(), other.startSession()) && Objects.equals(this.startTransaction(), other.startTransaction()) && Objects.equals(this.endSession(), other.endSession()) && Objects.equals(this.commitTransaction(), other.commitTransaction()) && Objects.equals(this.abortTransaction(), other.abortTransaction()) && Objects.equals(this.executeStatement(), other.executeStatement()) && Objects.equals(this.fetchPage(), other.fetchPage());
    }

    public final String toString() {
        return ToString.builder((String)"SendCommandResponse").add("StartSession", (Object)this.startSession()).add("StartTransaction", (Object)this.startTransaction()).add("EndSession", (Object)this.endSession()).add("CommitTransaction", (Object)this.commitTransaction()).add("AbortTransaction", (Object)this.abortTransaction()).add("ExecuteStatement", (Object)this.executeStatement()).add("FetchPage", (Object)this.fetchPage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartSession": {
                return Optional.ofNullable(clazz.cast(this.startSession()));
            }
            case "StartTransaction": {
                return Optional.ofNullable(clazz.cast(this.startTransaction()));
            }
            case "EndSession": {
                return Optional.ofNullable(clazz.cast(this.endSession()));
            }
            case "CommitTransaction": {
                return Optional.ofNullable(clazz.cast(this.commitTransaction()));
            }
            case "AbortTransaction": {
                return Optional.ofNullable(clazz.cast(this.abortTransaction()));
            }
            case "ExecuteStatement": {
                return Optional.ofNullable(clazz.cast(this.executeStatement()));
            }
            case "FetchPage": {
                return Optional.ofNullable(clazz.cast(this.fetchPage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartSession", START_SESSION_FIELD);
        map.put("StartTransaction", START_TRANSACTION_FIELD);
        map.put("EndSession", END_SESSION_FIELD);
        map.put("CommitTransaction", COMMIT_TRANSACTION_FIELD);
        map.put("AbortTransaction", ABORT_TRANSACTION_FIELD);
        map.put("ExecuteStatement", EXECUTE_STATEMENT_FIELD);
        map.put("FetchPage", FETCH_PAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendCommandResponse, T> g) {
        return obj -> g.apply((SendCommandResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbSessionResponse.BuilderImpl
    implements Builder {
        private StartSessionResult startSession;
        private StartTransactionResult startTransaction;
        private EndSessionResult endSession;
        private CommitTransactionResult commitTransaction;
        private AbortTransactionResult abortTransaction;
        private ExecuteStatementResult executeStatement;
        private FetchPageResult fetchPage;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandResponse model) {
            super(model);
            this.startSession(model.startSession);
            this.startTransaction(model.startTransaction);
            this.endSession(model.endSession);
            this.commitTransaction(model.commitTransaction);
            this.abortTransaction(model.abortTransaction);
            this.executeStatement(model.executeStatement);
            this.fetchPage(model.fetchPage);
        }

        public final StartSessionResult.Builder getStartSession() {
            return this.startSession != null ? this.startSession.toBuilder() : null;
        }

        public final void setStartSession(StartSessionResult.BuilderImpl startSession) {
            this.startSession = startSession != null ? startSession.build() : null;
        }

        @Override
        public final Builder startSession(StartSessionResult startSession) {
            this.startSession = startSession;
            return this;
        }

        public final StartTransactionResult.Builder getStartTransaction() {
            return this.startTransaction != null ? this.startTransaction.toBuilder() : null;
        }

        public final void setStartTransaction(StartTransactionResult.BuilderImpl startTransaction) {
            this.startTransaction = startTransaction != null ? startTransaction.build() : null;
        }

        @Override
        public final Builder startTransaction(StartTransactionResult startTransaction) {
            this.startTransaction = startTransaction;
            return this;
        }

        public final EndSessionResult.Builder getEndSession() {
            return this.endSession != null ? this.endSession.toBuilder() : null;
        }

        public final void setEndSession(EndSessionResult.BuilderImpl endSession) {
            this.endSession = endSession != null ? endSession.build() : null;
        }

        @Override
        public final Builder endSession(EndSessionResult endSession) {
            this.endSession = endSession;
            return this;
        }

        public final CommitTransactionResult.Builder getCommitTransaction() {
            return this.commitTransaction != null ? this.commitTransaction.toBuilder() : null;
        }

        public final void setCommitTransaction(CommitTransactionResult.BuilderImpl commitTransaction) {
            this.commitTransaction = commitTransaction != null ? commitTransaction.build() : null;
        }

        @Override
        public final Builder commitTransaction(CommitTransactionResult commitTransaction) {
            this.commitTransaction = commitTransaction;
            return this;
        }

        public final AbortTransactionResult.Builder getAbortTransaction() {
            return this.abortTransaction != null ? this.abortTransaction.toBuilder() : null;
        }

        public final void setAbortTransaction(AbortTransactionResult.BuilderImpl abortTransaction) {
            this.abortTransaction = abortTransaction != null ? abortTransaction.build() : null;
        }

        @Override
        public final Builder abortTransaction(AbortTransactionResult abortTransaction) {
            this.abortTransaction = abortTransaction;
            return this;
        }

        public final ExecuteStatementResult.Builder getExecuteStatement() {
            return this.executeStatement != null ? this.executeStatement.toBuilder() : null;
        }

        public final void setExecuteStatement(ExecuteStatementResult.BuilderImpl executeStatement) {
            this.executeStatement = executeStatement != null ? executeStatement.build() : null;
        }

        @Override
        public final Builder executeStatement(ExecuteStatementResult executeStatement) {
            this.executeStatement = executeStatement;
            return this;
        }

        public final FetchPageResult.Builder getFetchPage() {
            return this.fetchPage != null ? this.fetchPage.toBuilder() : null;
        }

        public final void setFetchPage(FetchPageResult.BuilderImpl fetchPage) {
            this.fetchPage = fetchPage != null ? fetchPage.build() : null;
        }

        @Override
        public final Builder fetchPage(FetchPageResult fetchPage) {
            this.fetchPage = fetchPage;
            return this;
        }

        @Override
        public SendCommandResponse build() {
            return new SendCommandResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QldbSessionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendCommandResponse> {
        public Builder startSession(StartSessionResult var1);

        default public Builder startSession(Consumer<StartSessionResult.Builder> startSession) {
            return this.startSession((StartSessionResult)((StartSessionResult.Builder)StartSessionResult.builder().applyMutation(startSession)).build());
        }

        public Builder startTransaction(StartTransactionResult var1);

        default public Builder startTransaction(Consumer<StartTransactionResult.Builder> startTransaction) {
            return this.startTransaction((StartTransactionResult)((StartTransactionResult.Builder)StartTransactionResult.builder().applyMutation(startTransaction)).build());
        }

        public Builder endSession(EndSessionResult var1);

        default public Builder endSession(Consumer<EndSessionResult.Builder> endSession) {
            return this.endSession((EndSessionResult)((EndSessionResult.Builder)EndSessionResult.builder().applyMutation(endSession)).build());
        }

        public Builder commitTransaction(CommitTransactionResult var1);

        default public Builder commitTransaction(Consumer<CommitTransactionResult.Builder> commitTransaction) {
            return this.commitTransaction((CommitTransactionResult)((CommitTransactionResult.Builder)CommitTransactionResult.builder().applyMutation(commitTransaction)).build());
        }

        public Builder abortTransaction(AbortTransactionResult var1);

        default public Builder abortTransaction(Consumer<AbortTransactionResult.Builder> abortTransaction) {
            return this.abortTransaction((AbortTransactionResult)((AbortTransactionResult.Builder)AbortTransactionResult.builder().applyMutation(abortTransaction)).build());
        }

        public Builder executeStatement(ExecuteStatementResult var1);

        default public Builder executeStatement(Consumer<ExecuteStatementResult.Builder> executeStatement) {
            return this.executeStatement((ExecuteStatementResult)((ExecuteStatementResult.Builder)ExecuteStatementResult.builder().applyMutation(executeStatement)).build());
        }

        public Builder fetchPage(FetchPageResult var1);

        default public Builder fetchPage(Consumer<FetchPageResult.Builder> fetchPage) {
            return this.fetchPage((FetchPageResult)((FetchPageResult.Builder)FetchPageResult.builder().applyMutation(fetchPage)).build());
        }
    }
}

