/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains I/O usage metrics for a command that was invoked.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IOUsage implements SdkPojo, Serializable, ToCopyableBuilder<IOUsage.Builder, IOUsage> {
    private static final SdkField<Long> READ_I_OS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ReadIOs")
            .getter(getter(IOUsage::readIOs)).setter(setter(Builder::readIOs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadIOs").build()).build();

    private static final SdkField<Long> WRITE_I_OS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("WriteIOs")
            .getter(getter(IOUsage::writeIOs)).setter(setter(Builder::writeIOs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteIOs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_I_OS_FIELD,
            WRITE_I_OS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long readIOs;

    private final Long writeIOs;

    private IOUsage(BuilderImpl builder) {
        this.readIOs = builder.readIOs;
        this.writeIOs = builder.writeIOs;
    }

    /**
     * <p>
     * The number of read I/O requests that the command made.
     * </p>
     * 
     * @return The number of read I/O requests that the command made.
     */
    public final Long readIOs() {
        return readIOs;
    }

    /**
     * <p>
     * The number of write I/O requests that the command made.
     * </p>
     * 
     * @return The number of write I/O requests that the command made.
     */
    public final Long writeIOs() {
        return writeIOs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readIOs());
        hashCode = 31 * hashCode + Objects.hashCode(writeIOs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IOUsage)) {
            return false;
        }
        IOUsage other = (IOUsage) obj;
        return Objects.equals(readIOs(), other.readIOs()) && Objects.equals(writeIOs(), other.writeIOs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IOUsage").add("ReadIOs", readIOs()).add("WriteIOs", writeIOs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadIOs":
            return Optional.ofNullable(clazz.cast(readIOs()));
        case "WriteIOs":
            return Optional.ofNullable(clazz.cast(writeIOs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReadIOs", READ_I_OS_FIELD);
        map.put("WriteIOs", WRITE_I_OS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IOUsage, T> g) {
        return obj -> g.apply((IOUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IOUsage> {
        /**
         * <p>
         * The number of read I/O requests that the command made.
         * </p>
         * 
         * @param readIOs
         *        The number of read I/O requests that the command made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readIOs(Long readIOs);

        /**
         * <p>
         * The number of write I/O requests that the command made.
         * </p>
         * 
         * @param writeIOs
         *        The number of write I/O requests that the command made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeIOs(Long writeIOs);
    }

    static final class BuilderImpl implements Builder {
        private Long readIOs;

        private Long writeIOs;

        private BuilderImpl() {
        }

        private BuilderImpl(IOUsage model) {
            readIOs(model.readIOs);
            writeIOs(model.writeIOs);
        }

        public final Long getReadIOs() {
            return readIOs;
        }

        public final void setReadIOs(Long readIOs) {
            this.readIOs = readIOs;
        }

        @Override
        public final Builder readIOs(Long readIOs) {
            this.readIOs = readIOs;
            return this;
        }

        public final Long getWriteIOs() {
            return writeIOs;
        }

        public final void setWriteIOs(Long writeIOs) {
            this.writeIOs = writeIOs;
        }

        @Override
        public final Builder writeIOs(Long writeIOs) {
            this.writeIOs = writeIOs;
            return this;
        }

        @Override
        public IOUsage build() {
            return new IOUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
