/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldbsession.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that can contain a value in multiple encoding formats.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValueHolder implements SdkPojo, Serializable, ToCopyableBuilder<ValueHolder.Builder, ValueHolder> {
    private static final SdkField<SdkBytes> ION_BINARY_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("IonBinary").getter(getter(ValueHolder::ionBinary)).setter(setter(Builder::ionBinary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IonBinary").build()).build();

    private static final SdkField<String> ION_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IonText").getter(getter(ValueHolder::ionText)).setter(setter(Builder::ionText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IonText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ION_BINARY_FIELD,
            ION_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes ionBinary;

    private final String ionText;

    private ValueHolder(BuilderImpl builder) {
        this.ionBinary = builder.ionBinary;
        this.ionText = builder.ionText;
    }

    /**
     * <p>
     * An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.
     * </p>
     * 
     * @return An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.
     */
    public final SdkBytes ionBinary() {
        return ionBinary;
    }

    /**
     * <p>
     * An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.
     * </p>
     * 
     * @return An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.
     */
    public final String ionText() {
        return ionText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ionBinary());
        hashCode = 31 * hashCode + Objects.hashCode(ionText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueHolder)) {
            return false;
        }
        ValueHolder other = (ValueHolder) obj;
        return Objects.equals(ionBinary(), other.ionBinary()) && Objects.equals(ionText(), other.ionText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValueHolder").add("IonBinary", ionBinary()).add("IonText", ionText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IonBinary":
            return Optional.ofNullable(clazz.cast(ionBinary()));
        case "IonText":
            return Optional.ofNullable(clazz.cast(ionText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IonBinary", ION_BINARY_FIELD);
        map.put("IonText", ION_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValueHolder, T> g) {
        return obj -> g.apply((ValueHolder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValueHolder> {
        /**
         * <p>
         * An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.
         * </p>
         * 
         * @param ionBinary
         *        An Amazon Ion binary value contained in a <code>ValueHolder</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ionBinary(SdkBytes ionBinary);

        /**
         * <p>
         * An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.
         * </p>
         * 
         * @param ionText
         *        An Amazon Ion plaintext value contained in a <code>ValueHolder</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ionText(String ionText);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes ionBinary;

        private String ionText;

        private BuilderImpl() {
        }

        private BuilderImpl(ValueHolder model) {
            ionBinary(model.ionBinary);
            ionText(model.ionText);
        }

        public final ByteBuffer getIonBinary() {
            return ionBinary == null ? null : ionBinary.asByteBuffer();
        }

        public final void setIonBinary(ByteBuffer ionBinary) {
            ionBinary(ionBinary == null ? null : SdkBytes.fromByteBuffer(ionBinary));
        }

        @Override
        public final Builder ionBinary(SdkBytes ionBinary) {
            this.ionBinary = ionBinary;
            return this;
        }

        public final String getIonText() {
            return ionText;
        }

        public final void setIonText(String ionText) {
            this.ionText = ionText;
        }

        @Override
        public final Builder ionText(String ionText) {
            this.ionText = ionText;
            return this;
        }

        @Override
        public ValueHolder build() {
            return new ValueHolder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
