/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;

/**
 * Service client for accessing Amazon QuickSight asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>Amazon QuickSight API Reference</fullname>
 * <p>
 * Amazon QuickSight is a fast, cloud-powered BI service that makes it easy to build visualizations, perform ad hoc
 * analysis, and quickly get business insights from your data. This API interface reference contains documentation for a
 * programming interface that you can use to manage Amazon QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface QuickSightAsyncClient extends SdkClient {
    String SERVICE_NAME = "quicksight";

    /**
     * Create a {@link QuickSightAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QuickSightAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QuickSightAsyncClient}.
     */
    static QuickSightAsyncClientBuilder builder() {
        return new DefaultQuickSightAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified doesn't exist.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request. The
     *        request object for this operation.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified doesn't exist.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * The response is the group member object.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            CreateGroupMembershipRequest createGroupMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <p>
     * The response is the group member object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGroupMembershipRequest#builder()}
     * </p>
     *
     * @param createGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            Consumer<CreateGroupMembershipRequest.Builder> createGroupMembershipRequest) {
        return createGroupMembership(CreateGroupMembershipRequest.builder().applyMutation(createGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            DeleteGroupMembershipRequest deleteGroupMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the user name.
     * </p>
     * <p>
     * The condition key is <code>quicksight:UserName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupMembershipRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGroupMembershipRequest#builder()}
     * </p>
     *
     * @param deleteGroupMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupMembershipRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroupMembership
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            Consumer<DeleteGroupMembershipRequest.Builder> deleteGroupMembershipRequest) {
        return deleteGroupMembership(DeleteGroupMembershipRequest.builder().applyMutation(deleteGroupMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt; </i> </code>.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt; </i> </code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is the group object.
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is the group object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeGroupResponse> describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest) {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon Resource Name (ARN), AWS Identity and Access
     * Management (IAM) role, and email address.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a user object that contains the user's Amazon Resource Name (ARN), AWS Identity and Access
     * Management (IAM) role, and email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Generates an embedded URL and authorization code. Before this can work properly, you need to configure the
     * dashboards and user permissions first.
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     * @return A Java Future containing the result of the GetDashboardEmbedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified doesn't exist.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>DomainNotWhitelistedException The domain specified is not on the allowlist. All domains for embedded
     *         dashboards must be added to the approved list by an Amazon QuickSight admin.</li>
     *         <li>QuickSightUserNotFoundException The user is not found. This could happen in any operation that
     *         requires finding a user based on the provided user name, such as DeleteUser, DescribeUser, and so on.</li>
     *         <li>IdentityTypeNotSupportedException The identity type specified is not supported. Supported identity
     *         types include: IAM and QUICKSIGHT.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session is invalid. The session lifetime must be between 15 and 600 minutes.</li>
     *         <li>UnsupportedUserEditionException Indicates that you are calling an operation on an Amazon QuickSight
     *         subscription where the edition does not include support for that operation. Amazon QuickSight currently
     *         has Standard Edition and Enterprise Edition. Not every operation and capability is available in every
     *         edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDashboardEmbedUrlResponse> getDashboardEmbedUrl(
            GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an embedded URL and authorization code. Before this can work properly, you need to configure the
     * dashboards and user permissions first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDashboardEmbedUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetDashboardEmbedUrlRequest#builder()}
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     *        A {@link Consumer} that will call methods on {@link GetDashboardEmbedUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDashboardEmbedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceExistsException The resource specified doesn't exist.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>DomainNotWhitelistedException The domain specified is not on the allowlist. All domains for embedded
     *         dashboards must be added to the approved list by an Amazon QuickSight admin.</li>
     *         <li>QuickSightUserNotFoundException The user is not found. This could happen in any operation that
     *         requires finding a user based on the provided user name, such as DeleteUser, DescribeUser, and so on.</li>
     *         <li>IdentityTypeNotSupportedException The identity type specified is not supported. Supported identity
     *         types include: IAM and QUICKSIGHT.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session is invalid. The session lifetime must be between 15 and 600 minutes.</li>
     *         <li>UnsupportedUserEditionException Indicates that you are calling an operation on an Amazon QuickSight
     *         subscription where the edition does not include support for that operation. Amazon QuickSight currently
     *         has Standard Edition and Enterprise Edition. Not every operation and capability is available in every
     *         edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GetDashboardEmbedUrl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDashboardEmbedUrlResponse> getDashboardEmbedUrl(
            Consumer<GetDashboardEmbedUrlRequest.Builder> getDashboardEmbedUrlRequest) {
        return getDashboardEmbedUrl(GetDashboardEmbedUrlRequest.builder().applyMutation(getDashboardEmbedUrlRequest).build());
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a list of group member objects.
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return A Java Future containing the result of the ListGroupMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsResponse> listGroupMemberships(
            ListGroupMembershipsRequest listGroupMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a list of group member objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembershipsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupMembershipsRequest#builder()}
     * </p>
     *
     * @param listGroupMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembershipsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGroupMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroupMemberships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupMembershipsResponse> listGroupMemberships(
            Consumer<ListGroupMembershipsRequest.Builder> listGroupMembershipsRequest) {
        return listGroupMemberships(ListGroupMembershipsRequest.builder().applyMutation(listGroupMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*</code>.
     * </p>
     * <p>
     * The response is a list of group objects.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*</code>.
     * </p>
     * <p>
     * The response is a list of group objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that a user is part of.
     * </p>
     *
     * @param listUserGroupsRequest
     * @return A Java Future containing the result of the ListUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserGroupsResponse> listUserGroups(ListUserGroupsRequest listUserGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that a user is part of.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListUserGroupsRequest#builder()}
     * </p>
     *
     * @param listUserGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListUserGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUserGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUserGroupsResponse> listUserGroups(Consumer<ListUserGroupsRequest.Builder> listUserGroupsRequest) {
        return listUserGroups(ListUserGroupsRequest.builder().applyMutation(listUserGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>*</i> </code>.
     * </p>
     * <p>
     * The response is a list of user objects, containing each user's Amazon Resource Name (ARN), AWS Identity and
     * Access Management (IAM) role, and email address.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>*</i> </code>.
     * </p>
     * <p>
     * The response is a list of user objects, containing each user's Amazon Resource Name (ARN), AWS Identity and
     * Access Management (IAM) role, and email address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the Amazon Resource Name (ARN) for the IAM user or role, and the session name.
     * </p>
     * <p>
     * The condition keys are <code>quicksight:IamArn</code> and <code>quicksight:SessionName</code>.
     * </p>
     *
     * @param registerUserRequest
     * @return A Java Future containing the result of the RegisterUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified doesn't exist.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterUserResponse> registerUser(RegisterUserRequest registerUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     * <p>
     * The permission resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt;</i> </code>.
     * </p>
     * <p>
     * The condition resource is the Amazon Resource Name (ARN) for the IAM user or role, and the session name.
     * </p>
     * <p>
     * The condition keys are <code>quicksight:IamArn</code> and <code>quicksight:SessionName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterUserRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterUserRequest#builder()}
     * </p>
     *
     * @param registerUserRequest
     *        A {@link Consumer} that will call methods on {@link RegisterUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified doesn't exist.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.RegisterUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterUserResponse> registerUser(Consumer<RegisterUserRequest.Builder> registerUserRequest) {
        return registerUser(RegisterUserRequest.builder().applyMutation(registerUserRequest).build());
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this.</li>
     *         <li>InvalidParameterValueException One or more parameters don't have a valid value.</li>
     *         <li>ResourceNotFoundException One or more resources couldn't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }
}
